/*
**	CCC -- Chord Chart Compiler
**	psl 12/85
*/
#include	<stdio.h>
#include	"midi.h"

#define	MAXCH		256
#define	NAMELEN		16
#define	MAXV		8

#define	BAR_PERIOD	(2 * MPU_CLOCK_PERIOD)

char	Ebuf[128];
int	Step		= BAR_PERIOD / 4;	/* defaults to quarter notes */
int	Style		= 'n';		/* legato, normal, or staccato */
int	Numchords	= 1;		/* "-" already defined */
long	Time		= 0;

struct	chstr	{
	char	name[NAMELEN];
	char	key[MAXV];
} Ch[MAXCH]	= {
	{ "-",	{ 0, }, },		/* to allow "-" to be used as a rest */
};

char	*speel(), *strcopy();

main(argc, argv)
char	*argv[];
{
	register int i;
	FILE *ifp;

	if (argc == 1)
	    process(stdin);
	else {
	    for (i = 1; i < argc; i++) {
		if ((ifp = fopen(argv[i], "r")) == NULL)
		    perror(argv[i]);
		else {
		    process(ifp);
		    fclose(ifp);
		}
	    }
	}
	exit(0);
}

process(ifp)
FILE	*ifp;
{
	register int v, chnum, lastchnum, m, n, dur;
	char *bp, *cp;
	char buf[512];

	while (fgets(bp = buf, sizeof buf, ifp) != NULL) {
	    cp = speel(&bp, 0);
	    if (*cp == '\n' || (cp[0] == '#' && cp[1] == '\0'))
		;
	    else if (*cp == '#')
		procntl(cp, bp);
	    else {
		dur = (Style == 's'? Step / 4 : Step);
		dur = (Style == 'n'? (4 * Step) / 5 : dur);
		lastchnum = -1;
		while (*cp) {
		    if (*cp == '/') {
			if ((chnum = lastchnum) == -1)
			    syntax("Line beginning with '/'");
		    } else {
			if ((chnum = find(cp)) < 0) {
			    sprintf(Ebuf, "Undefined chord: %s", cp);
			    syntax(Ebuf);
			}
		    }
		    for (v = 0; v < MAXV; v++) {
			n = Ch[chnum].key[v];
			if (Style == 'l' && lastchnum != -1) {
			    if ((m = Ch[lastchnum].key[v]) == n)
				continue;
			    if (m != 0) {
				putdt(Time, stdout);
				putc(m, stdout);
				putc(0, stdout);
			    }
			}
			if (n != 0) {
			    putdt(Time, stdout);
			    putc(0x90, stdout);
			    putc(n, stdout);
			    putc(0x40, stdout);
			}
		    }
		    lastchnum = chnum;
		    if (Style != 'l') {
			for (v = 0; v < MAXV && (n = Ch[chnum].key[v]); v++) {
			    putdt(Time + dur, stdout);
			    putc(n, stdout);
			    putc(0, stdout);
			}
		    }
		    Time += Step;
		    cp = speel(&bp, 0);
		}
		if (Style == 'l' && lastchnum != -1) {
		    for (v = 0; v < MAXV && (n = Ch[chnum].key[v]); v++) {
			putdt(Time, stdout);
			putc(n, stdout);
			putc(0, stdout);
		    }
		}
	    }
	}
}

procntl(cp, bp)
char	*cp, *bp;
{
	int cn, v;
	FILE *fp;

	if (wrdcmp(cp, "#CHORD") == 0) {
	    cp = speel(&bp, 0);
	    if ((cn = Numchords++) >= MAXCH)
		syntax("Too many chords defined");
	    strcopy(Ch[cn].name, cp);
	    for (v = 0; v < MAXV && (cp = speel(&bp, 0)) && *cp; v++)
		Ch[cn].key[v] = name2key(cp);
	} else if (wrdcmp(cp, "#INCLUDE") == 0) {
	    if (*bp++ != '"')
		syntax("#INCLUDE must use quotes (\")");
	    for (cp = bp; *cp && *cp != '"'; cp++);
	    if (*cp != '"')
		syntax("#INCLUDE must use quotes (\")");
	    *cp = '\0';
	    if ((fp = fopen(bp, "r")) == NULL) {
		perror(bp);
		exit(1);
	    }
	    process(fp);
	    fclose(fp);
	} else if (wrdcmp(cp, "#QUANTUM") == 0) {
	    if (wrdcmp(bp, "whole") == 0)
		Step = BAR_PERIOD;
	    else if (wrdcmp(bp, "half") == 0)
		Step = BAR_PERIOD / 2;
	    else if (wrdcmp(bp, "quarter") == 0)
		Step = BAR_PERIOD / 4;
	    else if (wrdcmp(bp, "eighth") == 0)
		Step = BAR_PERIOD / 8;
	    else if (wrdcmp(bp, "sixteenth") == 0)
		Step = BAR_PERIOD / 16;
	    else
		syntax("Unrecognized #QUANTUM arg");
	} else if (wrdcmp(cp, "#STYLE") == 0)
	    Style = *bp;
}

wrdcmp(ap, bp)
char	*ap, *bp;
{
	while (*bp && *ap == *bp) {
	    ap++;
	    bp++;
	}
	return ((*ap <= ' ' && *bp == '\0')? 0 : *ap - *bp);
}

syntax(msg)
char	*msg;
{
	fprintf(stderr, "Chord chart syntax error: %s\n", msg);
	exit(1);
}

putdt(time, ofp)
long	time;
FILE	*ofp;
{
	register int dt;
	static long last;

	dt = time - last;
	while (dt >= MPU_CLOCK_PERIOD) {
	    putc(RT_TCIP, ofp);
	    dt -= MPU_CLOCK_PERIOD;
	}
	putc(dt, ofp);
	last = time;
}

find(name)
char	*name;
{
	register int i;

	for (i = 0; i < Numchords; i++)
	    if (wrdcmp(name, Ch[i].name) == 0)
		return(i);
	return(-1);
}
