/*
**	CC2GC -- Chord Chart to Guitar Chord conversion
**	psl 12/85
*/
#include	<stdio.h>

#define	MAXCH		256
#define	NAMELEN		16

char	Ebuf[128];
int	Numchords	= 1;		/* "-" already defined */

struct	chstr	{
	char	name[NAMELEN];
	char	chord[64];
} Ch[MAXCH]	= {
	{ "-",	"- - - - - - - -\n", },	/* to allow "-" to be used as a rest */
};

extern	char	*speel(), *strcopy();

main(argc, argv)
char	*argv[];
{
	register int i;
	FILE *ifp;

	if (argc == 1)
	    process(stdin);
	else {
	    for (i = 1; i < argc; i++) {
		if ((ifp = fopen(argv[i], "r")) == NULL)
		    perror(argv[i]);
		else {
		    process(ifp);
		    fclose(ifp);
		}
	    }
	}
	exit(0);
}

process(ifp)
FILE	*ifp;
{
	char *bp, *cp;
	register int chnum, lastchnum;
	char buf[512];

	while (fgets(bp = buf, sizeof buf, ifp) != NULL) {
	    cp = speel(&bp, 0);
	    if (*cp == '\n' || (cp[0] == '#' && cp[1] == '\0'))
		printf("%s %s", cp, bp);
	    else if (*cp == '#')
		procntl(cp, bp);
	    else {
		lastchnum = -1;
		while (*cp) {
		    if (*cp == '/') {
			if ((chnum = lastchnum) == -1)
			    syntax("Line beginning with '/'");
		    } else {
			if ((chnum = find(cp)) < 0) {
			    sprintf(Ebuf, "Undefined chord: %s", cp);
			    syntax(Ebuf);
			}
		    }
		    printf("%s", Ch[chnum].chord);
		    lastchnum = chnum;
		    cp = speel(&bp, 0);
		}
	    }
	}
}

procntl(cp, bp)
char	*cp, *bp;
{
	int chnum, n;
	FILE *fp;

	if (wrdcmp(cp, "#CHORD") == 0) {
	    if ((chnum = Numchords++) >= MAXCH)
		syntax("Too many chords defined");
	    strcopy(Ch[chnum].name, speel(&bp, 0));
	    strcopy(Ch[chnum].chord, bp);
	} else if (wrdcmp(cp, "#INCLUDE") == 0) {
	    if (*bp++ != '"')
		syntax("#INCLUDE must use quotes (\")");
	    for (cp = bp; *cp && *cp != '"'; cp++);
	    if (*cp != '"')
		syntax("#INCLUDE must use quotes (\")");
	    *cp = '\0';
	    if ((fp = fopen(bp, "r")) == NULL) {
		perror(bp);
		exit(1);
	    }
	    process(fp);
	    fclose(fp);
	} else if (wrdcmp(cp, "#STYLE") == 0) {
	    if (wrdcmp(bp, "staccato") == 0)
		printf("#ARTIC\t0.25\n");
	    else if (wrdcmp(bp, "normal") == 0)
		printf("#ARTIC\t0.8\n");
	    else if (wrdcmp(bp, "legato") == 0)
		printf("#ARTIC\t1\n");
	    else
		syntax("Unrecognized \"#STYLE\" arg");
	} else if (wrdcmp(cp, "#QUANTUM") == 0) {
	    if (wrdcmp(bp, "whole") == 0)
		n = 1;
	    else if (wrdcmp(bp, "half") == 0)
		n = 2;
	    else if (wrdcmp(bp, "quarter") == 0)
		n = 4;
	    else if (wrdcmp(bp, "eighth") == 0)
		n = 8;
	    else if (wrdcmp(bp, "sixteenth") == 0)
		n = 16;
	    else {
		syntax("Unrecognized quantum arg");
		return;
	    }
	    printf("#SPEED\t%d\n", n);
	}
}

wrdcmp(ap, bp)
char	*ap, *bp;
{
	while (*bp && *ap == *bp) {
	    ap++;
	    bp++;
	}
	return ((*ap <= ' ' && *bp == '\0')? 0 : *ap - *bp);
}

syntax(msg)
char	*msg;
{
	fprintf(stderr, "Chord chart syntax error: %s\n", msg);
	exit(1);
}

find(name)
char	*name;
{
	register int i;

	for (i = 0; i < Numchords; i++)
	    if (wrdcmp(name, Ch[i].name) == 0)
		return(i);
	return(-1);
}
