/*
**	MPURESET -- Unclog the MPU
**	psl 3/88
*/
#include	<sys/ioctl.h>
#include	<mpuvar.h>

main(argc, argv)
char	*argv[];
{
	char *device;
	int fh;

	if (argc == 1)
	    device = "/dev/mpu0";
	else if (argc == 2)
	    device = argv[1];
	else {
	    write(2, "Usage: mpureset [/dev/mpu?]\n", 28);
	    write(2, "default is /dev/mpu0\n", 21);
	    exit(2);
	}
	if ((fh = open(device, 2)) < 0) {
	    perror(device);
	    exit(1);
	}
	ioctl(fh, MPU_IOC_PURGE, 0);
	close(fh);
	exit(0);
}
