BEGIN	{
	quant = 8		# eighth notes default
	tv = qtv[quant]
	coding = "abcdefg1234567ABCDEFG"	# must be 21 chars
	for (i = 1; i <= 21; i++) {
		code = substr(coding, i, 1)
		degree[code] = ((i - 1) % 7) + 1
		pitcheffect[code] = (int((i - 1) / 7) - 1) * 6
	}
	scale[1] = 0; scale[2] = 2; scale[3] = 4; scale[4] = 5
	scale[5] = 7; scale[6] = 9; scale[7] = 11
	qtv[1] = "w"
	qtv[2] = "h"; qtv[3] = "ht"
	qtv[4] = "q"; qtv[5] = "e."; qtv[6] = "qt";
	qtv[8] = "e"; qtv[10] = "s."; qtv[12] = "et"
	qtv[16] = "s"; qtv[20] = "t."; qtv[24] = "st"
	qtv[32] = "t"; qtv[48] = "tt"
	qtv[64] = "f"
	nname[1] = "C"; nname[2] = "C#"; nname[3] = "D"; nname[4] = "D#"
	nname[5] = "E"; nname[6] = "F"; nname[7] = "F#"; nname[8] = "G"
	nname[9] = "G#"; nname[10] = "A"; nname[11] = "A#"; nname[12] = "B"
	for (i = 1; i <= 12; i++)
		nnum[nname[i]] = i - 1
	mnum = 0
	mden = 1
}
$1 == "#VOICES"	{		# define output voices
	nv = NF - 1
	for (i = 0; i < nv; i++) {
		voice[i] = $(i+2)
		vn[$(i+2)] = i + 1;
		time[i] = 0
	}
	print
	next
}
$1 == "#INIT"	{		# give initial pitches (MIDI key #s) (stripped)
	if (nv > 0) {		# (VOICES must appear first)
		for (i = 0; i < nv; i++) {
			l = length($(i+2))
			oct = substr($(i+2), l, 1)
			nn = substr($(i+2), 1, l - 1)
			pitch[i] = (oct + 1) * 12 + nnum[nn]
		}
	}
	next
}
$1 == "#CODING"	{		# define the scale-degree encodings (stripped)
	coding = $2		# must be 21 chars
	if (length(coding) != 21) {
		print "#CODING arg must be 21 chars long"
		next
	}
	for (i = 1; i <= 21; i++) {
		code = substr(coding, i, 1)
		degree[code] = ((i - 1) % 7) + 1
		pitcheffect[code] = (int((i - 1) / 7) - 1) * 6
	}
}
$1 == "#SCALE"	{		# define the scale (stripped)
	slen = NF - 1
	for (i = 1; i <= slen; i++)
		scale[i] = nnum[$(i+1)]
	next
}
$1 == "#METER"	{		# define measure length
	mnum = $2
	mden = $3
	q[time[0]] = (quant * mnum) / mden
	print
	next
}
$1 == "#QUANT"	{		# quantization (stripped)
	if (nv > 0) {		# (VOICES must appear first)
		quant = $2
		tv = qtv[quant]
		q[time[0]] = (quant * mnum) / mden
	}
	next
}
$1 == "#"	{		# comments (stripped)
	next
}
/^#/	{			# controls for m-format
	print
	next
}
vn[$1] > 0	{		# melodic input
	v = vn[$1] - 1
	split($0, x, "	");	# x[2] has the scale degrees
	if ((n = split(x[2], y, "|")) > 1) {
		x[2] = y[1];		# remove any '|'
		for (i = 2; i <= n; i++)
			x[2] = x[2] y[i]
	}
	for (i = 0; (d = substr(x[2], i + 1, 1)) != ""; i++) {
		t = time[v] + i
		if (d == "^") {
			pitch[v] += 7
			d = " "
		} else if (d == "v") {
			pitch[v] -= 7
			d = " "
		}
		if (degree[d]) {
			pitch[v] += pitcheffect[d]
			s = scale[degree[d]]
			o = int((pitch[v] - s - 6) / 12)
			pitch[v] = 12 * o + s + 12
			p[t * nv + v] = sprintf "%s%d%s", nname[s+1], o, tv
		} else
			p[t * nv + v] = sprintf "R%s", tv
	}
	time[v] += i
}
END	{
	printf "#BAR\n"
	qib = 0
	for (t = 0; t < time[0]; t++) {
		if (q[t])
			qpm = q[t]
		printf "x"
		for (v = 0; v < nv; v++)
			printf "\t%s", p[t * nv + v]
		printf "\n"
		if (++qib >= qpm) {
			printf "#BAR\n"
			qib = 0
		}
	}
	printf "#BAR\n"
}
