# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential

from azure.mgmt.hardwaresecuritymodules import HardwareSecurityModulesMgmtClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-hardwaresecuritymodules
# USAGE
    python cloud_hsm_cluster_create_backup_maximum_set_gen_validate_backup_properties.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = HardwareSecurityModulesMgmtClient(
        credential=DefaultAzureCredential(),
        subscription_id="SUBSCRIPTION_ID",
    )

    response = client.cloud_hsm_clusters.begin_validate_backup_properties(
        resource_group_name="rgcloudhsm",
        cloud_hsm_cluster_name="chsm1",
    ).result()
    print(response)


# x-ms-original-file: 2025-03-31/CloudHsmCluster_Create_Backup_MaximumSet_Gen_ValidateBackupProperties.json
if __name__ == "__main__":
    main()
