# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.hdinsightcontainers.aio import HDInsightContainersMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestHDInsightContainersMgmtClustersOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(HDInsightContainersMgmtClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list_by_cluster_pool_name(self, resource_group):
        response = self.client.clusters.list_by_cluster_pool_name(
            resource_group_name=resource_group.name,
            cluster_pool_name="str",
            api_version="2024-05-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_upgrade(self, resource_group):
        response = await (
            await self.client.clusters.begin_upgrade(
                resource_group_name=resource_group.name,
                cluster_pool_name="str",
                cluster_name="str",
                cluster_upgrade_request={"properties": "cluster_upgrade_properties"},
                api_version="2024-05-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_upgrade_manual_rollback(self, resource_group):
        response = await (
            await self.client.clusters.begin_upgrade_manual_rollback(
                resource_group_name=resource_group.name,
                cluster_pool_name="str",
                cluster_name="str",
                cluster_rollback_upgrade_request={"properties": {"upgradeHistory": "str"}},
                api_version="2024-05-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_resize(self, resource_group):
        response = await (
            await self.client.clusters.begin_resize(
                resource_group_name=resource_group.name,
                cluster_pool_name="str",
                cluster_name="str",
                cluster_resize_request={
                    "location": "str",
                    "id": "str",
                    "name": "str",
                    "properties": {"targetWorkerNodeCount": 0},
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "tags": {"str": "str"},
                    "type": "str",
                },
                api_version="2024-05-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_get(self, resource_group):
        response = await self.client.clusters.get(
            resource_group_name=resource_group.name,
            cluster_pool_name="str",
            cluster_name="str",
            api_version="2024-05-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_create(self, resource_group):
        response = await (
            await self.client.clusters.begin_create(
                resource_group_name=resource_group.name,
                cluster_pool_name="str",
                cluster_name="str",
                hd_insight_cluster={
                    "location": "str",
                    "id": "str",
                    "name": "str",
                    "properties": {
                        "clusterProfile": {
                            "authorizationProfile": {"groupIds": ["str"], "userIds": ["str"]},
                            "clusterVersion": "str",
                            "ossVersion": "str",
                            "autoscaleProfile": {
                                "enabled": bool,
                                "autoscaleType": "str",
                                "gracefulDecommissionTimeout": 0,
                                "loadBasedConfig": {
                                    "maxNodes": 0,
                                    "minNodes": 0,
                                    "scalingRules": [
                                        {
                                            "actionType": "str",
                                            "comparisonRule": {"operator": "str", "threshold": 0.0},
                                            "evaluationCount": 0,
                                            "scalingMetric": "str",
                                        }
                                    ],
                                    "cooldownPeriod": 0,
                                    "pollInterval": 0,
                                },
                                "scheduleBasedConfig": {
                                    "defaultCount": 0,
                                    "schedules": [{"count": 0, "days": ["str"], "endTime": "str", "startTime": "str"}],
                                    "timeZone": "str",
                                },
                            },
                            "clusterAccessProfile": {"enableInternalIngress": bool, "privateLinkServiceId": "str"},
                            "components": [{"name": "str", "version": "str"}],
                            "connectivityProfile": {
                                "web": {"fqdn": "str", "privateFqdn": "str"},
                                "ssh": [{"endpoint": "str", "privateSshEndpoint": "str"}],
                            },
                            "flinkProfile": {
                                "jobManager": {"cpu": 0.0, "memory": 0},
                                "storage": {"storageUri": "str", "storagekey": "str"},
                                "taskManager": {"cpu": 0.0, "memory": 0},
                                "catalogOptions": {
                                    "hive": {
                                        "metastoreDbConnectionURL": "str",
                                        "metastoreDbConnectionAuthenticationMode": "str",
                                        "metastoreDbConnectionPasswordSecret": "str",
                                        "metastoreDbConnectionUserName": "str",
                                    }
                                },
                                "deploymentMode": "str",
                                "historyServer": {"cpu": 0.0, "memory": 0},
                                "jobSpec": {
                                    "jarName": "str",
                                    "jobJarDirectory": "str",
                                    "upgradeMode": "str",
                                    "args": "str",
                                    "entryClass": "str",
                                    "savePointName": "str",
                                },
                                "numReplicas": 0,
                            },
                            "identityProfile": {"msiClientId": "str", "msiObjectId": "str", "msiResourceId": "str"},
                            "kafkaProfile": {
                                "diskStorage": {"dataDiskSize": 0, "dataDiskType": "str"},
                                "connectivityEndpoints": {"bootstrapServerEndpoint": "str", "brokerEndpoints": ["str"]},
                                "enableKRaft": True,
                                "enablePublicEndpoints": False,
                                "remoteStorageUri": "str",
                            },
                            "llapProfile": {"str": {}},
                            "logAnalyticsProfile": {
                                "enabled": bool,
                                "applicationLogs": {"stdErrorEnabled": bool, "stdOutEnabled": bool},
                                "metricsEnabled": bool,
                            },
                            "managedIdentityProfile": {
                                "identityList": [
                                    {"clientId": "str", "objectId": "str", "resourceId": "str", "type": "str"}
                                ]
                            },
                            "prometheusProfile": {"enabled": False},
                            "rangerPluginProfile": {"enabled": False},
                            "rangerProfile": {
                                "rangerAdmin": {
                                    "admins": ["str"],
                                    "database": {
                                        "host": "str",
                                        "name": "str",
                                        "passwordSecretRef": "str",
                                        "username": "str",
                                    },
                                },
                                "rangerUsersync": {
                                    "enabled": True,
                                    "groups": ["str"],
                                    "mode": "automatic",
                                    "userMappingLocation": "str",
                                    "users": ["str"],
                                },
                                "rangerAudit": {"storageAccount": "str"},
                            },
                            "scriptActionProfiles": [
                                {
                                    "name": "str",
                                    "services": ["str"],
                                    "type": "str",
                                    "url": "str",
                                    "parameters": "str",
                                    "shouldPersist": True,
                                    "timeoutInMinutes": 0,
                                }
                            ],
                            "secretsProfile": {
                                "keyVaultResourceId": "str",
                                "secrets": [
                                    {
                                        "keyVaultObjectName": "str",
                                        "referenceName": "str",
                                        "type": "str",
                                        "version": "str",
                                    }
                                ],
                            },
                            "serviceConfigsProfiles": [
                                {
                                    "configs": [
                                        {
                                            "component": "str",
                                            "files": [
                                                {
                                                    "fileName": "str",
                                                    "content": "str",
                                                    "encoding": "str",
                                                    "path": "str",
                                                    "values": {"str": "str"},
                                                }
                                            ],
                                        }
                                    ],
                                    "serviceName": "str",
                                }
                            ],
                            "sparkProfile": {
                                "defaultStorageUrl": "str",
                                "metastoreSpec": {
                                    "dbName": "str",
                                    "dbServerHost": "str",
                                    "dbConnectionAuthenticationMode": "IdentityAuth",
                                    "dbPasswordSecretName": "str",
                                    "dbUserName": "str",
                                    "keyVaultId": "str",
                                    "thriftUrl": "str",
                                },
                                "userPluginsSpec": {"plugins": [{"path": "str"}]},
                            },
                            "sshProfile": {"count": 0, "podPrefix": "str", "vmSize": "str"},
                            "stubProfile": {"str": {}},
                            "trinoProfile": {
                                "catalogOptions": {
                                    "hive": [
                                        {
                                            "catalogName": "str",
                                            "metastoreDbConnectionURL": "str",
                                            "metastoreWarehouseDir": "str",
                                            "metastoreDbConnectionAuthenticationMode": "str",
                                            "metastoreDbConnectionPasswordSecret": "str",
                                            "metastoreDbConnectionUserName": "str",
                                        }
                                    ]
                                },
                                "coordinator": {
                                    "debug": {"enable": False, "port": 8008, "suspend": False},
                                    "highAvailabilityEnabled": True,
                                },
                                "userPluginsSpec": {"plugins": [{"enabled": bool, "name": "str", "path": "str"}]},
                                "userTelemetrySpec": {
                                    "storage": {
                                        "hivecatalogName": "str",
                                        "hivecatalogSchema": "trinologs",
                                        "partitionRetentionInDays": 365,
                                        "path": "str",
                                    }
                                },
                                "worker": {"debug": {"enable": False, "port": 8008, "suspend": False}},
                            },
                        },
                        "clusterType": "str",
                        "computeProfile": {
                            "nodes": [{"count": 0, "type": "str", "vmSize": "str"}],
                            "availabilityZones": ["str"],
                        },
                        "deploymentId": "str",
                        "provisioningState": "str",
                        "status": "str",
                    },
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "tags": {"str": "str"},
                    "type": "str",
                },
                api_version="2024-05-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_update(self, resource_group):
        response = await (
            await self.client.clusters.begin_update(
                resource_group_name=resource_group.name,
                cluster_pool_name="str",
                cluster_name="str",
                cluster_patch_request={
                    "properties": {
                        "clusterProfile": {
                            "authorizationProfile": {"groupIds": ["str"], "userIds": ["str"]},
                            "autoscaleProfile": {
                                "enabled": bool,
                                "autoscaleType": "str",
                                "gracefulDecommissionTimeout": 0,
                                "loadBasedConfig": {
                                    "maxNodes": 0,
                                    "minNodes": 0,
                                    "scalingRules": [
                                        {
                                            "actionType": "str",
                                            "comparisonRule": {"operator": "str", "threshold": 0.0},
                                            "evaluationCount": 0,
                                            "scalingMetric": "str",
                                        }
                                    ],
                                    "cooldownPeriod": 0,
                                    "pollInterval": 0,
                                },
                                "scheduleBasedConfig": {
                                    "defaultCount": 0,
                                    "schedules": [{"count": 0, "days": ["str"], "endTime": "str", "startTime": "str"}],
                                    "timeZone": "str",
                                },
                            },
                            "logAnalyticsProfile": {
                                "enabled": bool,
                                "applicationLogs": {"stdErrorEnabled": bool, "stdOutEnabled": bool},
                                "metricsEnabled": bool,
                            },
                            "prometheusProfile": {"enabled": False},
                            "rangerPluginProfile": {"enabled": False},
                            "rangerProfile": {
                                "rangerAdmin": {
                                    "admins": ["str"],
                                    "database": {
                                        "host": "str",
                                        "name": "str",
                                        "passwordSecretRef": "str",
                                        "username": "str",
                                    },
                                },
                                "rangerUsersync": {
                                    "enabled": True,
                                    "groups": ["str"],
                                    "mode": "automatic",
                                    "userMappingLocation": "str",
                                    "users": ["str"],
                                },
                                "rangerAudit": {"storageAccount": "str"},
                            },
                            "scriptActionProfiles": [
                                {
                                    "name": "str",
                                    "services": ["str"],
                                    "type": "str",
                                    "url": "str",
                                    "parameters": "str",
                                    "shouldPersist": True,
                                    "timeoutInMinutes": 0,
                                }
                            ],
                            "secretsProfile": {
                                "keyVaultResourceId": "str",
                                "secrets": [
                                    {
                                        "keyVaultObjectName": "str",
                                        "referenceName": "str",
                                        "type": "str",
                                        "version": "str",
                                    }
                                ],
                            },
                            "serviceConfigsProfiles": [
                                {
                                    "configs": [
                                        {
                                            "component": "str",
                                            "files": [
                                                {
                                                    "fileName": "str",
                                                    "content": "str",
                                                    "encoding": "str",
                                                    "path": "str",
                                                    "values": {"str": "str"},
                                                }
                                            ],
                                        }
                                    ],
                                    "serviceName": "str",
                                }
                            ],
                            "sshProfile": {"count": 0, "podPrefix": "str", "vmSize": "str"},
                            "trinoProfile": {
                                "catalogOptions": {
                                    "hive": [
                                        {
                                            "catalogName": "str",
                                            "metastoreDbConnectionURL": "str",
                                            "metastoreWarehouseDir": "str",
                                            "metastoreDbConnectionAuthenticationMode": "str",
                                            "metastoreDbConnectionPasswordSecret": "str",
                                            "metastoreDbConnectionUserName": "str",
                                        }
                                    ]
                                },
                                "coordinator": {
                                    "debug": {"enable": False, "port": 8008, "suspend": False},
                                    "highAvailabilityEnabled": True,
                                },
                                "userPluginsSpec": {"plugins": [{"enabled": bool, "name": "str", "path": "str"}]},
                                "userTelemetrySpec": {
                                    "storage": {
                                        "hivecatalogName": "str",
                                        "hivecatalogSchema": "trinologs",
                                        "partitionRetentionInDays": 365,
                                        "path": "str",
                                    }
                                },
                                "worker": {"debug": {"enable": False, "port": 8008, "suspend": False}},
                            },
                        }
                    },
                    "tags": {"str": "str"},
                },
                api_version="2024-05-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_delete(self, resource_group):
        response = await (
            await self.client.clusters.begin_delete(
                resource_group_name=resource_group.name,
                cluster_pool_name="str",
                cluster_name="str",
                api_version="2024-05-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list_service_configs(self, resource_group):
        response = self.client.clusters.list_service_configs(
            resource_group_name=resource_group.name,
            cluster_pool_name="str",
            cluster_name="str",
            api_version="2024-05-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list_instance_views(self, resource_group):
        response = self.client.clusters.list_instance_views(
            resource_group_name=resource_group.name,
            cluster_pool_name="str",
            cluster_name="str",
            api_version="2024-05-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_get_instance_view(self, resource_group):
        response = await self.client.clusters.get_instance_view(
            resource_group_name=resource_group.name,
            cluster_pool_name="str",
            cluster_name="str",
            api_version="2024-05-01-preview",
        )

        # please add some check logic here by yourself
        # ...
