# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential
from azure.mgmt.managedservices import ManagedServicesClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-managedservices
# USAGE
    python put_registration_definition.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = ManagedServicesClient(
        credential=DefaultAzureCredential(),
    )

    response = client.registration_definitions.begin_create_or_update(
        registration_definition_id="26c128c2-fefa-4340-9bb1-6e081c90ada2",
        scope="subscription/0afefe50-734e-4610-8a82-a144ahf49dea",
        request_body={
            "plan": {"name": "addesai-plan", "product": "test", "publisher": "marketplace-test", "version": "1.0.0"},
            "properties": {
                "authorizations": [
                    {
                        "principalId": "f98d86a2-4cc4-4e9d-ad47-b3e80a1bcdfc",
                        "principalIdDisplayName": "Support User",
                        "roleDefinitionId": "acdd72a7-3385-48ef-bd42-f606fba81ae7",
                    },
                    {
                        "delegatedRoleDefinitionIds": ["b24988ac-6180-42a0-ab88-20f7382dd24c"],
                        "principalId": "f98d86a2-4cc4-4e9d-ad47-b3e80a1bcdfc",
                        "principalIdDisplayName": "User Access Administrator",
                        "roleDefinitionId": "18d7d88d-d35e-4fb5-a5c3-7773c20a72d9",
                    },
                ],
                "description": "Tes1t",
                "eligibleAuthorizations": [
                    {
                        "justInTimeAccessPolicy": {
                            "managedByTenantApprovers": [
                                {
                                    "principalId": "d9b22cd6-6407-43cc-8c60-07c56df0b51a",
                                    "principalIdDisplayName": "Approver Group",
                                }
                            ],
                            "maximumActivationDuration": "PT8H",
                            "multiFactorAuthProvider": "Azure",
                        },
                        "principalId": "3e0ed8c6-e902-4fc5-863c-e3ddbb2ae2a2",
                        "principalIdDisplayName": "Support User",
                        "roleDefinitionId": "ae349356-3a1b-4a5e-921d-050484c6347e",
                    }
                ],
                "managedByTenantId": "83abe5cd-bcc3-441a-bd86-e6a75360cecc",
                "registrationDefinitionName": "DefinitionName",
            },
        },
    ).result()
    print(response)


# x-ms-original-file: specification/managedservices/resource-manager/Microsoft.ManagedServices/stable/2022-10-01/examples/PutRegistrationDefinition.json
if __name__ == "__main__":
    main()
