# Install the regular repository, et al.

readonly MSGG10=$(gettext\
 'stamping directories, installing the regular repository, symlinking currents, and setting permissions')
readonly MSGG20=$(gettext\
 'cannot move the regular repository to %s, for that node already exists')
readonly MSGG30=$(gettext\
 'something other than a file, directory or symlink is found in the repository')
readonly MSGG40=$(gettext\
 'broken symlink')
readonly MSGG60=$(gettext\
 'in the repository, cannot find zzz-dists/stable, zzz-dists/oldstable or the like')
readonly MSGG90=$(gettext\
 'done stamping directories, installing the regular repository, symlinking currents, and setting permissions')

declare OLDSTABLE_NAME FILE LINK
declare -i N_OLD
if (($OPT_PHASE_G)); then

    inform "$MSGG10..."

    # Let directory modification times equal release time.
    for DIR in $("$FINDX" '' '-type d' "$TARGET" "$ISOCD_TARGET"); do
        touch -hr "$TMPDIR/release.stamp" -- "$DIR"
    done

    # Install the regular repository; symlink currents.
    if (($OPT_PHASE_C)); then
        [ -e "$TARGET/dists/$DIST_CODENAME" ]\
         && die "$(printf "$MSGG20" "$TARGET/dists/$DIST_CODENAME")"
        mv $VV -- "$TARGET/dists/$DIST" "$TARGET/dists/$DIST_CODENAME"
        ln_touch "$DIST_CODENAME" "$TARGET/dists/$DIST"
        ln_touch "$DIST_CODENAME" "$TARGET/dists/stable"
        (($OPT_BACKPORTS)) && ln_touch\
         "$DIST_BACKPORTS" "$TARGET/dists/stable-backports"
        touch -hr "$TMPDIR/release.stamp" -- "$TARGET/dists" "$TARGET"
    fi
    if (($OPT_PHASE_F)); then
        ln_touch "$ISOCD_VER" "$ISOCD_TARGET/current"
        touch -hr "$TMPDIR/release.stamp" -- "$ISOCD_TARGET"
    fi

    # Canonicalize zzz-dists.  (The archive's zzz-dists renames stable as
    # oldstable upon a new major release.  That's fine, but for
    # reproducibility, it is not what the local repository wants.)
    #
    # Note: this operation may not precede the above installation of the
    # regular repository.
    OLDSTABLE_NAME='stable'
    N_OLD=0
    while true; do
        if [ -e "$TARGET/zzz-dists/$OLDSTABLE_NAME" ]; then
            mv -n$V -- "$TARGET/zzz-dists/$OLDSTABLE_NAME"\
             "$TARGET/zzz-dists/$DIST_CODENAME"
            break
        else
            OLDSTABLE_NAME="old$OLDSTABLE_NAME"
            ((++N_OLD))
            (($N_OLD <= $ZZZ_N_OLD_MAX)) || die "$MSGG60"
        fi
    done
    mkdir $VV -- "$TMPDIR/old-zzz-symlinks"
    pushd >/dev/null "$TARGET/dists/$DIST_CODENAME"
    for CTRL1 in $(find . -mindepth 1 -maxdepth 1 -type l); do
        CTRL=$(basename -- "$CTRL1")
        mv -n$V -- "$CTRL" "$TMPDIR/old-zzz-symlinks/"
        ln -s$V -- "../../zzz-dists/$DIST_CODENAME/$CTRL"
        touch -hr "$TMPDIR/old-zzz-symlinks/$CTRL" -- "$CTRL"
    done
    popd >/dev/null
    pushd >/dev/null "$TARGET"
    for DIR in {,zzz-}dists{,/$DIST_CODENAME} .; do
        touch -hr "$TMPDIR/release.stamp" -- "$DIR"
    done
    popd >/dev/null

    # Verify that the mirrored repository have nothing
    # but files, directories and symlinks.
    if [[ -n "$(
        "$FINDX" '' '! -type f -a ! -type d -a ! -type l'\
        "$TARGET" "$ISOCD_TARGET"
    )" ]]; then
        die "$MSGG30"
    fi

    # Check for broken symlinks.
    if [[ -n "$(
        "$FINDX" '-L' '-type l' "$TARGET" "$ISOCD_TARGET"
    )" ]]; then
        die "$MSGG40"
    fi

    # If a symlink points directly or indirectly at anything but a file (or
    # points directly or indirectly at nothing), then let the symlink's
    # time equal release time.
    for LINK in $("$FINDX" '' '-type l' "$TARGET" "$ISOCD_TARGET"); do
        [ -f "$(realpath -m -- $LINK)" ]\
        || touch -hr "$TMPDIR/release.stamp" -- "$LINK"
    done

    # Set permissions.
    for DIR in\
        $("$FINDX" '' '-mindepth 1 -type d' "$TARGET" "$ISOCD_TARGET")
    do
        chmod $VV -- 0755 "$DIR"
    done
    for FILE in\
        $("$FINDX" '' '-mindepth 1 -type f' "$TARGET" "$ISOCD_TARGET")
    do
        chmod $VV -- 0644 "$FILE"
    done

    inform "$MSGG90"

fi

