/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.internal.tools.ant.taskdefs;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.taskdefs.Javac;
import org.apache.tools.ant.taskdefs.Zip;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.ZipFileSet;
import org.aspectj.internal.tools.ant.taskdefs.ProductBuilder;
import org.aspectj.internal.tools.ant.taskdefs.ProjectMessager;
import org.aspectj.internal.tools.build.BuildSpec;
import org.aspectj.internal.tools.build.Builder;
import org.aspectj.internal.tools.build.Messager;
import org.aspectj.internal.tools.build.Module;
import org.aspectj.internal.tools.build.Result;
import org.aspectj.internal.tools.build.Util;

public class AntBuilder
extends Builder {
    private static final boolean FORCE_FORK_FOR_LIBRARIES = false;
    private final Project project;
    static /* synthetic */ Class class$org$apache$tools$ant$Task;
    static /* synthetic */ Class class$org$apache$tools$ant$taskdefs$Javac;
    static /* synthetic */ Class class$org$apache$tools$ant$types$Path;

    public static Builder getBuilder(String config, Project project, File tempDir) {
        boolean useEclipseCompiles = false;
        boolean verbose = false;
        if (null != config) {
            if (-1 != config.indexOf("useEclipseCompiles")) {
                useEclipseCompiles = true;
            }
            if (-1 != config.indexOf("verbose")) {
                verbose = true;
            }
        }
        ProjectMessager handler = new ProjectMessager(project);
        ProductBuilder result = new ProductBuilder(project, tempDir, useEclipseCompiles, handler);
        if (verbose) {
            result.setVerbose(true);
        }
        return result;
    }

    private static String resultToTargetName(Result result) {
        return result.getName();
    }

    private static void makeTargetsForResult(Result result, Hashtable targets) {
        String resultTargetName = AntBuilder.resultToTargetName(result);
        Target target = (Target)targets.get(resultTargetName);
        if (null == target) {
            Result reqResult;
            int i;
            target = new Target();
            target.setName(resultTargetName);
            Result[] reqs = result.getRequired();
            StringBuffer depends = new StringBuffer();
            boolean first = true;
            for (i = 0; i < reqs.length; ++i) {
                reqResult = reqs[i];
                if (!first) {
                    depends.append(",");
                } else {
                    first = false;
                }
                depends.append(AntBuilder.resultToTargetName(reqResult));
            }
            if (0 < depends.length()) {
                target.setDepends(depends.toString());
            }
            targets.put(resultTargetName, target);
            for (i = 0; i < reqs.length; ++i) {
                reqResult = reqs[i];
                AntBuilder.makeTargetsForResult(reqResult, targets);
            }
        }
    }

    protected AntBuilder(Project project, File tempDir, boolean useEclipseCompiles, Messager handler) {
        super(tempDir, useEclipseCompiles, handler);
        this.project = project;
        Util.iaxIfNull(project, "project");
    }

    protected boolean setupTask(Task task, String name) {
        task.setProject(this.project);
        task.setTaskName("ajbuild-" + name);
        return true;
    }

    protected boolean copyFile(File fromFile, File toFile, boolean filter) {
        Copy copy = this.makeCopyTask(filter);
        copy.setFile(fromFile);
        copy.setTofile(toFile);
        this.executeTask((Task)copy);
        return true;
    }

    protected boolean copyFiles(File fromDir, File toDir, String includes, String excludes, boolean filter) {
        Copy copy = this.makeCopyTask(filter);
        copy.setTodir(toDir);
        FileSet fileset = new FileSet();
        fileset.setDir(fromDir);
        if (null != includes) {
            fileset.setIncludes(includes);
        }
        if (null != excludes) {
            fileset.setExcludes(excludes);
        }
        copy.addFileset(fileset);
        this.executeTask((Task)copy);
        return false;
    }

    protected void copyFileset(File toDir, FileSet fileSet, boolean filter) {
        Copy copy = this.makeCopyTask(filter);
        copy.addFileset(fileSet);
        copy.setTodir(toDir);
        this.executeTask((Task)copy);
    }

    protected Copy makeCopyTask(boolean filter) {
        Copy copy = new Copy();
        this.setupTask((Task)copy, "copy");
        if (filter) {
            copy.setFiltering(true);
        }
        return copy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dumpMinFile(Result result, File classesDir, List errors) {
        String name = result.getName() + "-empty";
        File minFile = new File(classesDir, name);
        FileWriter fw = null;
        try {
            fw = new FileWriter(minFile);
            fw.write(name);
        }
        catch (IOException e) {
            try {
                errors.add("IOException writing " + name + " to " + minFile + ": " + Util.renderException(e));
            }
            catch (Throwable throwable) {
                Util.close(fw);
                throw throwable;
            }
            Util.close(fw);
        }
        Util.close(fw);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean compile(Result result, File classesDir, boolean useExistingClasses, List errors) {
        boolean passed;
        Javac javac;
        block24: {
            if (!classesDir.exists() && !classesDir.mkdirs()) {
                errors.add("compile - unable to create " + classesDir);
                return false;
            }
            if (useExistingClasses) {
                return true;
            }
            Path path = new Path(this.project);
            boolean hasSourceDirectories = false;
            boolean isJava5Compile = false;
            Iterator iter = result.getSrcDirs().iterator();
            while (iter.hasNext()) {
                File file = (File)iter.next();
                path.createPathElement().setLocation(file);
                if (!isJava5Compile && ("java5-src".equals(file.getName()) || "java5-testsrc".equals(file.getName()) || new File(file.getParent(), ".isJava5").exists())) {
                    isJava5Compile = true;
                }
                if (hasSourceDirectories) continue;
                hasSourceDirectories = true;
            }
            if (!hasSourceDirectories) {
                return true;
            }
            javac = new Javac();
            this.setupTask((Task)javac, "javac");
            javac.setIncludeantruntime(false);
            javac.setDestdir(classesDir);
            javac.setSrcdir(path);
            javac.setVerbose(this.verbose);
            path = null;
            Path classpath = new Path(this.project);
            boolean hasLibraries = this.setupClasspath(result, classpath);
            if (hasLibraries) {
                // empty if block
            }
            classpath.createPathElement().setLocation(classesDir);
            javac.setClasspath(classpath);
            javac.setDebug(true);
            if (!isJava5Compile) {
                javac.setTarget("1.1");
                javac.setSource("1.3");
            } else {
                javac.setSource("1.5");
                javac.setTarget("1.5");
            }
            passed = false;
            BuildException failure = null;
            try {
                try {
                    passed = this.executeTask(AspectJSupport.wrapIfNeeded(result, javac));
                }
                catch (BuildException e) {
                    failure = e;
                    Object var15_14 = null;
                    if (!passed) {
                        String args = "" + Arrays.asList(javac.getCurrentCompilerArgs());
                        if ("[]".equals(args)) {
                            args = "{" + result.toLongString() + "}";
                        }
                        String m = "BuildException compiling " + result.toLongString() + args + (null == failure ? "" : ": " + Util.renderException(failure));
                        errors.add(m);
                    }
                    javac.init();
                    return passed;
                }
                catch (Error e) {
                    failure = new BuildException((Throwable)e);
                    Object var15_15 = null;
                    if (!passed) {
                        String args = "" + Arrays.asList(javac.getCurrentCompilerArgs());
                        if ("[]".equals(args)) {
                            args = "{" + result.toLongString() + "}";
                        }
                        String m = "BuildException compiling " + result.toLongString() + args + (null == failure ? "" : ": " + Util.renderException(failure));
                        errors.add(m);
                    }
                    javac.init();
                    return passed;
                }
                catch (RuntimeException e) {
                    failure = new BuildException((Throwable)e);
                    Object var15_16 = null;
                    if (!passed) {
                        String args = "" + Arrays.asList(javac.getCurrentCompilerArgs());
                        if ("[]".equals(args)) {
                            args = "{" + result.toLongString() + "}";
                        }
                        String m = "BuildException compiling " + result.toLongString() + args + (null == failure ? "" : ": " + Util.renderException(failure));
                        errors.add(m);
                    }
                    javac.init();
                    return passed;
                }
                Object var15_13 = null;
                if (passed) break block24;
                String args = "" + Arrays.asList(javac.getCurrentCompilerArgs());
                if ("[]".equals(args)) {
                    args = "{" + result.toLongString() + "}";
                }
                String m = "BuildException compiling " + result.toLongString() + args + (null == failure ? "" : ": " + Util.renderException(failure));
                errors.add(m);
            }
            catch (Throwable throwable) {
                Object var15_17 = null;
                if (!passed) {
                    String args = "" + Arrays.asList(javac.getCurrentCompilerArgs());
                    if ("[]".equals(args)) {
                        args = "{" + result.toLongString() + "}";
                    }
                    String m = "BuildException compiling " + result.toLongString() + args + (null == failure ? "" : ": " + Util.renderException(failure));
                    errors.add(m);
                }
                javac.init();
                throw throwable;
            }
        }
        javac.init();
        return passed;
    }

    public boolean setupClasspath(Result result, Path classpath) {
        boolean hasLibraries = false;
        Iterator iter = result.getLibJars().iterator();
        while (iter.hasNext()) {
            File file = (File)iter.next();
            classpath.createPathElement().setLocation(file);
            if (hasLibraries) continue;
            hasLibraries = true;
        }
        Result[] reqs = result.getRequired();
        for (int i = 0; i < reqs.length; ++i) {
            Result requiredResult = reqs[i];
            classpath.createPathElement().setLocation(requiredResult.getOutputFile());
            if (!hasLibraries) {
                hasLibraries = true;
            }
            Iterator iterator = requiredResult.getExportedLibJars().iterator();
            while (iterator.hasNext()) {
                classpath.createPathElement().setLocation((File)iterator.next());
            }
        }
        return hasLibraries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean assemble(Result result, File classesDir, List errors) {
        if (!this.buildingEnabled) {
            return false;
        }
        if (!result.outOfDate()) {
            return true;
        }
        Zip zip = new Zip();
        this.setupTask((Task)zip, "zip");
        zip.setDestFile(result.getOutputFile());
        ZipFileSet zipfileset = null;
        Iterator iter = result.getSrcDirs().iterator();
        while (iter.hasNext()) {
            File srcDir = (File)iter.next();
            zipfileset = new ZipFileSet();
            zipfileset.setProject(this.project);
            zipfileset.setDir(srcDir);
            zipfileset.setIncludes(Builder.RESOURCE_PATTERN);
            zip.addZipfileset(zipfileset);
        }
        Module module = result.getModule();
        File metaInfDir = new File(classesDir, "META-INF");
        Util.deleteContents(metaInfDir);
        File manifest = new File(module.moduleDir, module.name + ".mf.txt");
        if (Util.canReadFile(manifest)) {
            if (Util.canReadDir(metaInfDir) || metaInfDir.mkdirs()) {
                this.copyFile(manifest, new File(metaInfDir, "MANIFEST.MF"), true);
            } else {
                errors.add("have manifest, but unable to create " + metaInfDir);
                return false;
            }
        }
        zipfileset = new ZipFileSet();
        zipfileset.setProject(this.project);
        zipfileset.setDir(classesDir);
        zipfileset.setIncludes("**/*");
        zip.addZipfileset(zipfileset);
        File[] contents = classesDir.listFiles();
        if (null == contents || 0 == contents.length) {
            this.dumpMinFile(result, classesDir, errors);
        }
        try {
            this.handler.log("assemble " + module + " in " + result.getOutputFile());
            boolean bl = this.executeTask((Task)zip) && Util.canReadFile(result.getOutputFile());
            Object var13_12 = null;
            result.clearOutOfDate();
            return bl;
        }
        catch (BuildException e) {
            try {
                errors.add("BuildException zipping " + module + ": " + e.getMessage());
                boolean bl = false;
                Object var13_13 = null;
                result.clearOutOfDate();
                return bl;
            }
            catch (Throwable throwable) {
                Object var13_14 = null;
                result.clearOutOfDate();
                throw throwable;
            }
        }
    }

    protected Result[] getAntecedantResults(Result moduleResult) {
        Hashtable targets = new Hashtable();
        AntBuilder.makeTargetsForResult(moduleResult, targets);
        String targetName = AntBuilder.resultToTargetName(moduleResult);
        Vector result = this.project.topoSort(targetName, targets);
        int size = result.size();
        if (0 == result.size()) {
            return new Result[0];
        }
        ArrayList<String> toReturn = new ArrayList<String>();
        Iterator iter = result.iterator();
        while (iter.hasNext()) {
            Target target = (Target)iter.next();
            String name = target.getName();
            if (null == name) {
                throw new Error("null name?");
            }
            toReturn.add(name);
        }
        if (1 == size && targetName.equals(toReturn.get(0)) && !moduleResult.outOfDate()) {
            return new Result[0];
        }
        return Result.getResults(toReturn.toArray(new String[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean assembleAll(Result result, Messager handler) {
        if (!this.buildingEnabled) {
            return false;
        }
        if (!result.outOfDate()) {
            return true;
        }
        Util.iaxIfNull(result, "result");
        Util.iaxIfNull(handler, "handler");
        if (!result.getKind().isAssembly()) {
            throw new IllegalStateException("not assembly: " + result);
        }
        Zip zip = new Zip();
        this.setupTask((Task)zip, "zip");
        zip.setDestFile(result.getOutputFile());
        ZipFileSet zipfileset = null;
        Module module = result.getModule();
        List known = result.findJarRequirements();
        this.removeLibraryFilesToSkip(module, known);
        Iterator iter2 = known.iterator();
        while (iter2.hasNext()) {
            File jarFile = (File)iter2.next();
            zipfileset = new ZipFileSet();
            zipfileset.setProject(this.project);
            zipfileset.setSrc(jarFile);
            zipfileset.setIncludes("**/*");
            String name = jarFile.getName();
            name = name.substring(0, name.length() - 4);
            if (!module.name.equals(name)) {
                zipfileset.setExcludes("META-INF/MANIFEST.MF");
                zipfileset.setExcludes("META-INF/manifest.mf");
                zipfileset.setExcludes("meta-inf/manifest.mf");
                zipfileset.setExcludes("meta-inf/MANIFEST.MF");
            }
            zip.addZipfileset(zipfileset);
        }
        try {
            handler.log("assembling all " + module + " in " + result.getOutputFile());
            if (this.verbose) {
                handler.log("knownAntecedants: " + known);
            }
            boolean iter2 = this.executeTask((Task)zip);
            Object var11_13 = null;
            result.clearOutOfDate();
            return iter2;
        }
        catch (BuildException e) {
            try {
                handler.logException("BuildException zipping " + module, e);
                boolean bl = false;
                Object var11_14 = null;
                result.clearOutOfDate();
                return bl;
            }
            catch (Throwable throwable) {
                Object var11_15 = null;
                result.clearOutOfDate();
                throw throwable;
            }
        }
    }

    protected boolean buildInstaller(BuildSpec buildSpec, String targDirPath) {
        return false;
    }

    protected boolean executeTask(Task task) {
        if (!this.buildingEnabled) {
            return false;
        }
        task.execute();
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class AspectJSupport {
        static final String AJCTASK = "org.aspectj.tools.ant.taskdefs.AjcTask";
        static final String ASPECTJRT_JAR_VARIABLE = "ASPECTJRT_LIB";
        static final String LIBASPECTJ_RPATH = "/lib/aspectj";
        static final Map nameToAspectjrtjar = new HashMap();
        static final String NONE = "NONE";

        static Task wrapIfNeeded(Result result, Javac javac) {
            Project project = javac.getProject();
            Path runtimeJar = null;
            Module module = result.getModule();
            if (!AspectJSupport.runtimeJarOnClasspath(result)) {
                if (result.getClasspathVariables().contains(ASPECTJRT_JAR_VARIABLE)) {
                    runtimeJar = AspectJSupport.getAspectJLib(project, module, "aspectjrt.jar");
                } else {
                    return javac;
                }
            }
            Path aspectjtoolsJar = AspectJSupport.getAspectJLib(project, module, "aspectjtools.jar");
            return AspectJSupport.aspectJTask(javac, aspectjtoolsJar, runtimeJar);
        }

        private static boolean runtimeJarOnClasspath(Result result) {
            Iterator iter = result.getLibJars().iterator();
            while (iter.hasNext()) {
                File file = (File)iter.next();
                if (!"aspectjrt.jar".equals(file.getName())) continue;
                return true;
            }
            return false;
        }

        static Path getAspectJLib(Project project, Module module, String name) {
            Path result = null;
            String[] libDirNames = new String[]{"aspectj.home", "ASPECTJ_HOME", LIBASPECTJ_RPATH};
            String[] libDirs = new String[libDirNames.length];
            for (int i = 0; i < libDirNames.length; ++i) {
                libDirs[i] = LIBASPECTJ_RPATH == libDirNames[i] ? module.getFullPath(LIBASPECTJ_RPATH) : project.getProperty(libDirNames[i]);
                if (null == libDirs[i]) continue;
                libDirs[i] = Util.path(libDirs[i], "lib");
                result = new Path(project, Util.path(libDirs[i], name));
                String path = result.toString();
                if (!new File(path).canRead()) continue;
                return result;
            }
            String m = "unable to find " + name + " in " + Arrays.asList(libDirs);
            throw new BuildException(m);
        }

        static Task aspectJTask(Javac javac, Path toolsJar, Path runtimeJar) {
            Object task = null;
            String url = null;
            try {
                url = "file:" + toolsJar.toString().replace('\\', '/');
                URL[] cp = new URL[]{new URL(url)};
                ClassLoader parent = (class$org$apache$tools$ant$Task == null ? (class$org$apache$tools$ant$Task = AntBuilder.class$("org.apache.tools.ant.Task")) : class$org$apache$tools$ant$Task).getClassLoader();
                URLClassLoader loader = new URLClassLoader(cp, parent);
                Class<?> c = loader.loadClass(AJCTASK);
                task = c.newInstance();
                Method m = c.getMethod("setupAjc", class$org$apache$tools$ant$taskdefs$Javac == null ? (class$org$apache$tools$ant$taskdefs$Javac = AntBuilder.class$("org.apache.tools.ant.taskdefs.Javac")) : class$org$apache$tools$ant$taskdefs$Javac);
                m.invoke(task, javac);
                m = c.getMethod("setFork", Boolean.TYPE);
                m.invoke(task, Boolean.TRUE);
                m = c.getMethod("setForkclasspath", class$org$apache$tools$ant$types$Path == null ? (class$org$apache$tools$ant$types$Path = AntBuilder.class$("org.apache.tools.ant.types.Path")) : class$org$apache$tools$ant$types$Path);
                m.invoke(task, toolsJar);
                m = c.getMethod("setSourceRoots", class$org$apache$tools$ant$types$Path == null ? (class$org$apache$tools$ant$types$Path = AntBuilder.class$("org.apache.tools.ant.types.Path")) : class$org$apache$tools$ant$types$Path);
                m.invoke(task, javac.getSrcdir());
                if (null != runtimeJar) {
                    m = c.getMethod("setClasspath", class$org$apache$tools$ant$types$Path == null ? (class$org$apache$tools$ant$types$Path = AntBuilder.class$("org.apache.tools.ant.types.Path")) : class$org$apache$tools$ant$types$Path);
                    m.invoke(task, runtimeJar);
                }
            }
            catch (BuildException e) {
                throw e;
            }
            catch (Throwable t) {
                StringBuffer sb = new StringBuffer();
                sb.append("classpath=");
                sb.append(url);
                throw new BuildException(sb.toString(), t);
            }
            return task;
        }

        private AspectJSupport() {
            throw new Error("no instances");
        }
    }
}

