/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 15:38:53 GMT 2018
 */

package uk.ac.sanger.artemis.io;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.io.Reader;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.io.EmblStreamSequence;
import uk.ac.sanger.artemis.io.FastaStreamSequence;
import uk.ac.sanger.artemis.io.GenbankStreamFeature;
import uk.ac.sanger.artemis.io.GenbankStreamSequence;
import uk.ac.sanger.artemis.io.RawStreamSequence;
import uk.ac.sanger.artemis.util.LinePushBackReader;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class StreamSequence_ESTest extends StreamSequence_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("BNyod$ZFBSlPh-c1%DI");
      // Undeclared exception!
      try { 
        rawStreamSequence0.getSubSequence((-626), (-626));
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // -314
         //
         verifyException("uk.ac.sanger.artemis.io.StreamSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("x1T:MlWi'Sd3p", "x1T:MlWi'Sd3p");
      char[] charArray0 = new char[7];
      fastaStreamSequence0.setFromChar(charArray0);
      assertEquals(7, fastaStreamSequence0.length());
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("relationship");
      genbankStreamSequence0.getFormatType();
      assertEquals(10, genbankStreamSequence0.getOtherCount());
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("");
      char[] charArray0 = emblStreamSequence0.getCharSequence();
      assertArrayEquals(new char[] {}, charArray0);
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("~z>Lx#!`A-");
      // Undeclared exception!
      try { 
        genbankStreamSequence0.setSequencePackingCapacity((-796));
        fail("Expecting exception: NegativeArraySizeException");
      
      } catch(NegativeArraySizeException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.StreamSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("8vB?I1zi?^_TGA-_");
      // Undeclared exception!
      try { 
        emblStreamSequence0.charAt(1490);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // 744
         //
         verifyException("uk.ac.sanger.artemis.io.StreamSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("@jnpNEty:]<]");
      // Undeclared exception!
      try { 
        genbankStreamSequence0.getCharSubSequence(600, 600);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // 299
         //
         verifyException("uk.ac.sanger.artemis.io.StreamSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("");
      // Undeclared exception!
      try { 
        fastaStreamSequence0.setFromChar((char[]) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.StreamSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("");
      int int0 = emblStreamSequence0.getACount();
      assertEquals(0, int0);
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      GenbankStreamFeature genbankStreamFeature0 = new GenbankStreamFeature();
      uk.ac.sanger.artemis.Feature feature0 = new uk.ac.sanger.artemis.Feature(genbankStreamFeature0);
      Reader reader0 = feature0.toReader();
      LinePushBackReader linePushBackReader0 = new LinePushBackReader(reader0);
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence(linePushBackReader0);
      int int0 = rawStreamSequence0.getCCount();
      assertEquals(0, rawStreamSequence0.getOtherCount());
      assertEquals(0, int0);
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("");
      int int0 = emblStreamSequence0.getGCount();
      assertEquals(0, int0);
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("pBhLW~@q>c/0<9'Q_cl");
      assertEquals(2, emblStreamSequence0.getCCount());
      
      emblStreamSequence0.setCounts();
      assertEquals(15, emblStreamSequence0.getOtherCount());
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("xEYR+2\"");
      char[] charArray0 = new char[1];
      fastaStreamSequence0.appendChar(charArray0);
      assertEquals(8, fastaStreamSequence0.getOtherCount());
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("x1T:MlWi'Sd3p", "x1T:MlWi'Sd3p");
      fastaStreamSequence0.getCharSequence();
      assertEquals(14, fastaStreamSequence0.length());
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("org.apache.log4j.spi.ThrowableInformation");
      // Undeclared exception!
      try { 
        fastaStreamSequence0.copy();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.RawStreamSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("x1T:MlWi'Sd3p", "x1T:MlWi'Sd3p");
      char[] charArray0 = new char[7];
      fastaStreamSequence0.appendChar(charArray0);
      fastaStreamSequence0.getCharSequence();
      assertEquals(21, fastaStreamSequence0.length());
  }

  @Test(timeout = 4000)
  public void test16()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("x1T:MlWi'Sd3p", "x1T:MlWi'Sd3p");
      fastaStreamSequence0.forceReset();
      assertEquals(14, fastaStreamSequence0.getOtherCount());
  }

  @Test(timeout = 4000)
  public void test17()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("", "");
      int int0 = fastaStreamSequence0.getOtherCount();
      assertEquals(0, int0);
  }

  @Test(timeout = 4000)
  public void test18()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("");
      emblStreamSequence0.setSequencePackingCapacity(855);
      assertEquals(0, emblStreamSequence0.getGCount());
  }
}
