/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 12:44:08 GMT 2018
 */

package uk.ac.sanger.artemis.components;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.awt.event.ItemListener;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.components.KeyChoice;
import uk.ac.sanger.artemis.io.BlastEntryInformation;
import uk.ac.sanger.artemis.io.EntryInformation;
import uk.ac.sanger.artemis.io.Key;
import uk.ac.sanger.artemis.io.SimpleEntryInformation;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class KeyChoice_ESTest extends KeyChoice_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      BlastEntryInformation blastEntryInformation0 = new BlastEntryInformation();
      Key key0 = blastEntryInformation0.getDefaultKey();
      blastEntryInformation0.addKey(key0);
      Key key1 = Key.CDS;
      blastEntryInformation0.addKey(key1);
      KeyChoice keyChoice0 = new KeyChoice(blastEntryInformation0, key1);
      assertTrue(keyChoice0.getFocusTraversalKeysEnabled());
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      BlastEntryInformation blastEntryInformation0 = new BlastEntryInformation();
      KeyChoice keyChoice0 = new KeyChoice(blastEntryInformation0);
      Key key0 = new Key("");
      keyChoice0.setKey(key0);
      Key key1 = keyChoice0.getSelectedItem();
      assertEquals(0, key1.length());
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      EntryInformation entryInformation0 = SimpleEntryInformation.getDefaultEntryInformation();
      KeyChoice keyChoice0 = new KeyChoice(entryInformation0);
      // Undeclared exception!
      try { 
        keyChoice0.setKey((Key) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.KeyChoice", e);
      }
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      BlastEntryInformation blastEntryInformation0 = new BlastEntryInformation();
      Key key0 = blastEntryInformation0.getDefaultKey();
      KeyChoice keyChoice0 = null;
      try {
        keyChoice0 = new KeyChoice((EntryInformation) null, key0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.KeyChoice", e);
      }
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      KeyChoice keyChoice0 = null;
      try {
        keyChoice0 = new KeyChoice((EntryInformation) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.KeyChoice", e);
      }
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      BlastEntryInformation blastEntryInformation0 = new BlastEntryInformation();
      Key key0 = new Key("NFa");
      KeyChoice keyChoice0 = new KeyChoice(blastEntryInformation0, key0);
      assertFalse(keyChoice0.getIgnoreRepaint());
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      BlastEntryInformation blastEntryInformation0 = new BlastEntryInformation();
      KeyChoice keyChoice0 = new KeyChoice(blastEntryInformation0);
      Key key0 = new Key("");
      keyChoice0.setKey(key0);
      keyChoice0.setKey(key0);
      assertEquals(0, key0.length());
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      BlastEntryInformation blastEntryInformation0 = new BlastEntryInformation();
      KeyChoice keyChoice0 = new KeyChoice(blastEntryInformation0);
      Key key0 = keyChoice0.getSelectedItem();
      assertEquals("CDS", key0.toString());
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      BlastEntryInformation blastEntryInformation0 = new BlastEntryInformation();
      KeyChoice keyChoice0 = new KeyChoice(blastEntryInformation0);
      keyChoice0.addItemListener((ItemListener) null);
      assertFalse(keyChoice0.isFocusTraversalPolicySet());
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      EntryInformation entryInformation0 = SimpleEntryInformation.getDefaultEntryInformation();
      KeyChoice keyChoice0 = new KeyChoice(entryInformation0);
      keyChoice0.removeItemListener((ItemListener) null);
      assertTrue(keyChoice0.getFocusTraversalKeysEnabled());
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      SimpleEntryInformation simpleEntryInformation0 = new SimpleEntryInformation();
      KeyChoice keyChoice0 = new KeyChoice(simpleEntryInformation0);
      keyChoice0.setEnabled(true);
  }
}
