/* crash.c - demo program for libcrashreport

   (c) 2004 Martin Pitt <martin@piware.de>

   This file is public domain.
*/

#include <stdio.h>
#include <math.h>
#include <signal.h>

double h()
{
    double a = 1./0;
    if (isinf(a))
	raise(SIGFPE);
    return a;
}

int g( int x, int y )
{
    
    return x+y+(int) h();
}

int f( int x )
{
    return g( x, 42 );
}

int
main()
{
    int x;

    x = f(1);
    printf( "x = %i, terminating normally now.\n", x );
    return 0;
}
