// SPDX-License-Identifier: GPL-2.0+
/* vim: set ts=8 sw=8 noet tw=80 nowrap: */
/*
 *  comedi/drivers/ni_routing/ni_route_values/ni_mseries.c
 *  Route information for NI_MSERIES boards.
 *
 *  COMEDI - Linux Control and Measurement Device Interface
 *  Copyright (C) 2016 Spencer E. Olson <olsonse@umich.edu>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 */

/*
 * This file includes a list of all the values of various signals routes
 * available on NI 660x hardware.  In many cases, one does not explicitly make
 * these routes, rather one might indicate that something is used as the source
 * of one particular trigger or another (using *_src=TRIG_EXT).
 *
 * The contents of this file can be generated using the tools in
 * comedi/drivers/ni_routing/tools.  This file also contains specific notes to
 * this family of devices.
 *
 * Please use those tools to help maintain the contents of this file, but be
 * mindful to not lose the notes already made in this file, since these notes
 * are critical to a complete undertsanding of the register values of this
 * family.
 */

#include "../ni_route_values.h"
#include "all.h"

/*
 * GATE SELECT NOTE:
 * CtrAux and CtrArmStartrigger register values are not documented in the
 * DAQ-STC.  There is some evidence that using CtrGate values is valid (see
 * comedi.h).  Some information and hints exist in the M-Series user manual
 * (ni-62xx user-manual 371022K-01).
 */

const struct family_route_values ni_mseries_route_values = {
	.family = "ni_mseries",
	.register_values = {
		/*
		 * destination = {
		 *              source          = register value,
		 *              ...
		 * }
		 */
		[B(NI_PFI(0))] = {
			[B(TRIGGER_LINE(0))]	= I(18),
			[B(TRIGGER_LINE(1))]	= I(19),
			[B(TRIGGER_LINE(2))]	= I(20),
			[B(TRIGGER_LINE(3))]	= I(21),
			[B(TRIGGER_LINE(4))]	= I(22),
			[B(TRIGGER_LINE(5))]	= I(23),
			[B(TRIGGER_LINE(6))]	= I(24),
			[B(TRIGGER_LINE(7))]	= I(25),
			[B(NI_CtrSource(0))]	= I(9),
			[B(NI_CtrSource(1))]	= I(4),
			[B(NI_CtrGate(0))]	= I(10),
			[B(NI_CtrGate(1))]	= I(5),
			[B(NI_CtrInternalOutput(0))]	= I(13),
			[B(NI_CtrInternalOutput(1))]	= I(14),
			[B(PXI_Star)]	= I(26),
			[B(NI_AI_SampleClock)]	= I(8),
			[B(NI_AI_StartTrigger)]	= I(1),
			[B(NI_AI_ReferenceTrigger)]	= I(2),
			[B(NI_AI_ConvertClock)]	= I(3),
			[B(NI_AI_ExternalMUXClock)]	= I(12),
			[B(NI_AO_SampleClock)]	= I(6),
			[B(NI_AO_StartTrigger)]	= I(7),
			[B(NI_DI_SampleClock)]	= I(29),
			[B(NI_DO_SampleClock)]	= I(30),
			[B(NI_FrequencyOutput)]	= I(15),
			[B(NI_ChangeDetectionEvent)]	= I(28),
			[B(NI_AnalogComparisonEvent)]	= I(17),
			[B(NI_SCXI_Trig1)]	= I(27),
			[B(NI_ExternalStrobe)]	= I(11),
			[B(NI_PFI_DO)]	= I(16),
		},
		[B(NI_PFI(1))] = {
			[B(TRIGGER_LINE(0))]	= I(18),
			[B(TRIGGER_LINE(1))]	= I(19),
			[B(TRIGGER_LINE(2))]	= I(20),
			[B(TRIGGER_LINE(3))]	= I(21),
			[B(TRIGGER_LINE(4))]	= I(22),
			[B(TRIGGER_LINE(5))]	= I(23),
			[B(TRIGGER_LINE(6))]	= I(24),
			[B(TRIGGER_LINE(7))]	= I(25),
			[B(NI_CtrSource(0))]	= I(9),
			[B(NI_CtrSource(1))]	= I(4),
			[B(NI_CtrGate(0))]	= I(10),
			[B(NI_CtrGate(1))]	= I(5),
			[B(NI_CtrInternalOutput(0))]	= I(13),
			[B(NI_CtrInternalOutput(1))]	= I(14),
			[B(PXI_Star)]	= I(26),
			[B(NI_AI_SampleClock)]	= I(8),
			[B(NI_AI_StartTrigger)]	= I(1),
			[B(NI_AI_ReferenceTrigger)]	= I(2),
			[B(NI_AI_ConvertClock)]	= I(3),
			[B(NI_AI_ExternalMUXClock)]	= I(12),
			[B(NI_AO_SampleClock)]	= I(6),
			[B(NI_AO_StartTrigger)]	= I(7),
			[B(NI_DI_SampleClock)]	= I(29),
			[B(NI_DO_SampleClock)]	= I(30),
			[B(NI_FrequencyOutput)]	= I(15),
			[B(NI_ChangeDetectionEvent)]	= I(28),
			[B(NI_AnalogComparisonEvent)]	= I(17),
			[B(NI_SCXI_Trig1)]	= I(27),
			[B(NI_ExternalStrobe)]	= I(11),
			[B(NI_PFI_DO)]	= I(16),
		},
		[B(NI_PFI(2))] = {
			[B(TRIGGER_LINE(0))]	= I(18),
			[B(TRIGGER_LINE(1))]	= I(19),
			[B(TRIGGER_LINE(2))]	= I(20),
			[B(TRIGGER_LINE(3))]	= I(21),
			[B(TRIGGER_LINE(4))]	= I(22),
			[B(TRIGGER_LINE(5))]	= I(23),
			[B(TRIGGER_LINE(6))]	= I(24),
			[B(TRIGGER_LINE(7))]	= I(25),
			[B(NI_CtrSource(0))]	= I(9),
			[B(NI_CtrSource(1))]	= I(4),
			[B(NI_CtrGate(0))]	= I(10),
			[B(NI_CtrGate(1))]	= I(5),
			[B(NI_CtrInternalOutput(0))]	= I(13),
			[B(NI_CtrInternalOutput(1))]	= I(14),
			[B(PXI_Star)]	= I(26),
			[B(NI_AI_SampleClock)]	= I(8),
			[B(NI_AI_StartTrigger)]	= I(1),
			[B(NI_AI_ReferenceTrigger)]	= I(2),
			[B(NI_AI_ConvertClock)]	= I(3),
			[B(NI_AI_ExternalMUXClock)]	= I(12),
			[B(NI_AO_SampleClock)]	= I(6),
			[B(NI_AO_StartTrigger)]	= I(7),
			[B(NI_DI_SampleClock)]	= I(29),
			[B(NI_DO_SampleClock)]	= I(30),
			[B(NI_FrequencyOutput)]	= I(15),
			[B(NI_ChangeDetectionEvent)]	= I(28),
			[B(NI_AnalogComparisonEvent)]	= I(17),
			[B(NI_SCXI_Trig1)]	= I(27),
			[B(NI_ExternalStrobe)]	= I(11),
			[B(NI_PFI_DO)]	= I(16),
		},
		[B(NI_PFI(3))] = {
			[B(TRIGGER_LINE(0))]	= I(18),
			[B(TRIGGER_LINE(1))]	= I(19),
			[B(TRIGGER_LINE(2))]	= I(20),
			[B(TRIGGER_LINE(3))]	= I(21),
			[B(TRIGGER_LINE(4))]	= I(22),
			[B(TRIGGER_LINE(5))]	= I(23),
			[B(TRIGGER_LINE(6))]	= I(24),
			[B(TRIGGER_LINE(7))]	= I(25),
			[B(NI_CtrSource(0))]	= I(9),
			[B(NI_CtrSource(1))]	= I(4),
			[B(NI_CtrGate(0))]	= I(10),
			[B(NI_CtrGate(1))]	= I(5),
			[B(NI_CtrInternalOutput(0))]	= I(13),
			[B(NI_CtrInternalOutput(1))]	= I(14),
			[B(PXI_Star)]	= I(26),
			[B(NI_AI_SampleClock)]	= I(8),
			[B(NI_AI_StartTrigger)]	= I(1),
			[B(NI_AI_ReferenceTrigger)]	= I(2),
			[B(NI_AI_ConvertClock)]	= I(3),
			[B(NI_AI_ExternalMUXClock)]	= I(12),
			[B(NI_AO_SampleClock)]	= I(6),
			[B(NI_AO_StartTrigger)]	= I(7),
			[B(NI_DI_SampleClock)]	= I(29),
			[B(NI_DO_SampleClock)]	= I(30),
			[B(NI_FrequencyOutput)]	= I(15),
			[B(NI_ChangeDetectionEvent)]	= I(28),
			[B(NI_AnalogComparisonEvent)]	= I(17),
			[B(NI_SCXI_Trig1)]	= I(27),
			[B(NI_ExternalStrobe)]	= I(11),
			[B(NI_PFI_DO)]	= I(16),
		},
		[B(NI_PFI(4))] = {
			[B(TRIGGER_LINE(0))]	= I(18),
			[B(TRIGGER_LINE(1))]	= I(19),
			[B(TRIGGER_LINE(2))]	= I(20),
			[B(TRIGGER_LINE(3))]	= I(21),
			[B(TRIGGER_LINE(4))]	= I(22),
			[B(TRIGGER_LINE(5))]	= I(23),
			[B(TRIGGER_LINE(6))]	= I(24),
			[B(TRIGGER_LINE(7))]	= I(25),
			[B(NI_CtrSource(0))]	= I(9),
			[B(NI_CtrSource(1))]	= I(4),
			[B(NI_CtrGate(0))]	= I(10),
			[B(NI_CtrGate(1))]	= I(5),
			[B(NI_CtrInternalOutput(0))]	= I(13),
			[B(NI_CtrInternalOutput(1))]	= I(14),
			[B(PXI_Star)]	= I(26),
			[B(NI_AI_SampleClock)]	= I(8),
			[B(NI_AI_StartTrigger)]	= I(1),
			[B(NI_AI_ReferenceTrigger)]	= I(2),
			[B(NI_AI_ConvertClock)]	= I(3),
			[B(NI_AI_ExternalMUXClock)]	= I(12),
			[B(NI_AO_SampleClock)]	= I(6),
			[B(NI_AO_StartTrigger)]	= I(7),
			[B(NI_DI_SampleClock)]	= I(29),
			[B(NI_DO_SampleClock)]	= I(30),
			[B(NI_FrequencyOutput)]	= I(15),
			[B(NI_ChangeDetectionEvent)]	= I(28),
			[B(NI_AnalogComparisonEvent)]	= I(17),
			[B(NI_SCXI_Trig1)]	= I(27),
			[B(NI_ExternalStrobe)]	= I(11),
			[B(NI_PFI_DO)]	= I(16),
		},
		[B(NI_PFI(5))] = {
			[B(TRIGGER_LINE(0))]	= I(18),
			[B(TRIGGER_LINE(1))]	= I(19),
			[B(TRIGGER_LINE(2))]	= I(20),
			[B(TRIGGER_LINE(3))]	= I(21),
			[B(TRIGGER_LINE(4))]	= I(22),
			[B(TRIGGER_LINE(5))]	= I(23),
			[B(TRIGGER_LINE(6))]	= I(24),
			[B(TRIGGER_LINE(7))]	= I(25),
			[B(NI_CtrSource(0))]	= I(9),
			[B(NI_CtrSource(1))]	= I(4),
			[B(NI_CtrGate(0))]	= I(10),
			[B(NI_CtrGate(1))]	= I(5),
			[B(NI_CtrInternalOutput(0))]	= I(13),
			[B(NI_CtrInternalOutput(1))]	= I(14),
			[B(PXI_Star)]	= I(26),
			[B(NI_AI_SampleClock)]	= I(8),
			[B(NI_AI_StartTrigger)]	= I(1),
			[B(NI_AI_ReferenceTrigger)]	= I(2),
			[B(NI_AI_ConvertClock)]	= I(3),
			[B(NI_AI_ExternalMUXClock)]	= I(12),
			[B(NI_AO_SampleClock)]	= I(6),
			[B(NI_AO_StartTrigger)]	= I(7),
			[B(NI_DI_SampleClock)]	= I(29),
			[B(NI_DO_SampleClock)]	= I(30),
			[B(NI_FrequencyOutput)]	= I(15),
			[B(NI_ChangeDetectionEvent)]	= I(28),
			[B(NI_AnalogComparisonEvent)]	= I(17),
			[B(NI_SCXI_Trig1)]	= I(27),
			[B(NI_ExternalStrobe)]	= I(11),
			[B(NI_PFI_DO)]	= I(16),
		},
		[B(NI_PFI(6))] = {
			[B(TRIGGER_LINE(0))]	= I(18),
			[B(TRIGGER_LINE(1))]	= I(19),
			[B(TRIGGER_LINE(2))]	= I(20),
			[B(TRIGGER_LINE(3))]	= I(21),
			[B(TRIGGER_LINE(4))]	= I(22),
			[B(TRIGGER_LINE(5))]	= I(23),
			[B(TRIGGER_LINE(6))]	= I(24),
			[B(TRIGGER_LINE(7))]	= I(25),
			[B(NI_CtrSource(0))]	= I(9),
			[B(NI_CtrSource(1))]	= I(4),
			[B(NI_CtrGate(0))]	= I(10),
			[B(NI_CtrGate(1))]	= I(5),
			[B(NI_CtrInternalOutput(0))]	= I(13),
			[B(NI_CtrInternalOutput(1))]	= I(14),
			[B(PXI_Star)]	= I(26),
			[B(NI_AI_SampleClock)]	= I(8),
			[B(NI_AI_StartTrigger)]	= I(1),
			[B(NI_AI_ReferenceTrigger)]	= I(2),
			[B(NI_AI_ConvertClock)]	= I(3),
			[B(NI_AI_ExternalMUXClock)]	= I(12),
			[B(NI_AO_SampleClock)]	= I(6),
			[B(NI_AO_StartTrigger)]	= I(7),
			[B(NI_DI_SampleClock)]	= I(29),
			[B(NI_DO_SampleClock)]	= I(30),
			[B(NI_FrequencyOutput)]	= I(15),
			[B(NI_ChangeDetectionEvent)]	= I(28),
			[B(NI_AnalogComparisonEvent)]	= I(17),
			[B(NI_SCXI_Trig1)]	= I(27),
			[B(NI_ExternalStrobe)]	= I(11),
			[B(NI_PFI_DO)]	= I(16),
		},
		[B(NI_PFI(7))] = {
			[B(TRIGGER_LINE(0))]	= I(18),
			[B(TRIGGER_LINE(1))]	= I(19),
			[B(TRIGGER_LINE(2))]	= I(20),
			[B(TRIGGER_LINE(3))]	= I(21),
			[B(TRIGGER_LINE(4))]	= I(22),
			[B(TRIGGER_LINE(5))]	= I(23),
			[B(TRIGGER_LINE(6))]	= I(24),
			[B(TRIGGER_LINE(7))]	= I(25),
			[B(NI_CtrSource(0))]	= I(9),
			[B(NI_CtrSource(1))]	= I(4),
			[B(NI_CtrGate(0))]	= I(10),
			[B(NI_CtrGate(1))]	= I(5),
			[B(NI_CtrInternalOutput(0))]	= I(13),
			[B(NI_CtrInternalOutput(1))]	= I(14),
			[B(PXI_Star)]	= I(26),
			[B(NI_AI_SampleClock)]	= I(8),
			[B(NI_AI_StartTrigger)]	= I(1),
			[B(NI_AI_ReferenceTrigger)]	= I(2),
			[B(NI_AI_ConvertClock)]	= I(3),
			[B(NI_AI_ExternalMUXClock)]	= I(12),
			[B(NI_AO_SampleClock)]	= I(6),
			[B(NI_AO_StartTrigger)]	= I(7),
			[B(NI_DI_SampleClock)]	= I(29),
			[B(NI_DO_SampleClock)]	= I(30),
			[B(NI_FrequencyOutput)]	= I(15),
			[B(NI_ChangeDetectionEvent)]	= I(28),
			[B(NI_AnalogComparisonEvent)]	= I(17),
			[B(NI_SCXI_Trig1)]	= I(27),
			[B(NI_ExternalStrobe)]	= I(11),
			[B(NI_PFI_DO)]	= I(16),
		},
		[B(NI_PFI(8))] = {
			[B(TRIGGER_LINE(0))]	= I(18),
			[B(TRIGGER_LINE(1))]	= I(19),
			[B(TRIGGER_LINE(2))]	= I(20),
			[B(TRIGGER_LINE(3))]	= I(21),
			[B(TRIGGER_LINE(4))]	= I(22),
			[B(TRIGGER_LINE(5))]	= I(23),
			[B(TRIGGER_LINE(6))]	= I(24),
			[B(TRIGGER_LINE(7))]	= I(25),
			[B(NI_CtrSource(0))]	= I(9),
			[B(NI_CtrSource(1))]	= I(4),
			[B(NI_CtrGate(0))]	= I(10),
			[B(NI_CtrGate(1))]	= I(5),
			[B(NI_CtrInternalOutput(0))]	= I(13),
			[B(NI_CtrInternalOutput(1))]	= I(14),
			[B(PXI_Star)]	= I(26),
			[B(NI_AI_SampleClock)]	= I(8),
			[B(NI_AI_StartTrigger)]	= I(1),
			[B(NI_AI_ReferenceTrigger)]	= I(2),
			[B(NI_AI_ConvertClock)]	= I(3),
			[B(NI_AI_ExternalMUXClock)]	= I(12),
			[B(NI_AO_SampleClock)]	= I(6),
			[B(NI_AO_StartTrigger)]	= I(7),
			[B(NI_DI_SampleClock)]	= I(29),
			[B(NI_DO_SampleClock)]	= I(30),
			[B(NI_FrequencyOutput)]	= I(15),
			[B(NI_ChangeDetectionEvent)]	= I(28),
			[B(NI_AnalogComparisonEvent)]	= I(17),
			[B(NI_SCXI_Trig1)]	= I(27),
			[B(NI_ExternalStrobe)]	= I(11),
			[B(NI_PFI_DO)]	= I(16),
		},
		[B(NI_PFI(9))] = {
			[B(TRIGGER_LINE(0))]	= I(18),
			[B(TRIGGER_LINE(1))]	= I(19),
			[B(TRIGGER_LINE(2))]	= I(20),
			[B(TRIGGER_LINE(3))]	= I(21),
			[B(TRIGGER_LINE(4))]	= I(22),
			[B(TRIGGER_LINE(5))]	= I(23),
			[B(TRIGGER_LINE(6))]	= I(24),
			[B(TRIGGER_LINE(7))]	= I(25),
			[B(NI_CtrSource(0))]	= I(9),
			[B(NI_CtrSource(1))]	= I(4),
			[B(NI_CtrGate(0))]	= I(10),
			[B(NI_CtrGate(1))]	= I(5),
			[B(NI_CtrInternalOutput(0))]	= I(13),
			[B(NI_CtrInternalOutput(1))]	= I(14),
			[B(PXI_Star)]	= I(26),
			[B(NI_AI_SampleClock)]	= I(8),
			[B(NI_AI_StartTrigger)]	= I(1),
			[B(NI_AI_ReferenceTrigger)]	= I(2),
			[B(NI_AI_ConvertClock)]	= I(3),
			[B(NI_AI_ExternalMUXClock)]	= I(12),
			[B(NI_AO_SampleClock)]	= I(6),
			[B(NI_AO_StartTrigger)]	= I(7),
			[B(NI_DI_SampleClock)]	= I(29),
			[B(NI_DO_SampleClock)]	= I(30),
			[B(NI_FrequencyOutput)]	= I(15),
			[B(NI_ChangeDetectionEvent)]	= I(28),
			[B(NI_AnalogComparisonEvent)]	= I(17),
			[B(NI_SCXI_Trig1)]	= I(27),
			[B(NI_ExternalStrobe)]	= I(11),
			[B(NI_PFI_DO)]	= I(16),
		},
		[B(NI_PFI(10))] = {
			[B(TRIGGER_LINE(0))]	= I(18),
			[B(TRIGGER_LINE(1))]	= I(19),
			[B(TRIGGER_LINE(2))]	= I(20),
			[B(TRIGGER_LINE(3))]	= I(21),
			[B(TRIGGER_LINE(4))]	= I(22),
			[B(TRIGGER_LINE(5))]	= I(23),
			[B(TRIGGER_LINE(6))]	= I(24),
			[B(TRIGGER_LINE(7))]	= I(25),
			[B(NI_CtrSource(0))]	= I(9),
			[B(NI_CtrSource(1))]	= I(4),
			[B(NI_CtrGate(0))]	= I(10),
			[B(NI_CtrGate(1))]	= I(5),
			[B(NI_CtrInternalOutput(0))]	= I(13),
			[B(NI_CtrInternalOutput(1))]	= I(14),
			[B(PXI_Star)]	= I(26),
			[B(NI_AI_SampleClock)]	= I(8),
			[B(NI_AI_StartTrigger)]	= I(1),
			[B(NI_AI_ReferenceTrigger)]	= I(2),
			[B(NI_AI_ConvertClock)]	= I(3),
			[B(NI_AI_ExternalMUXClock)]	= I(12),
			[B(NI_AO_SampleClock)]	= I(6),
			[B(NI_AO_StartTrigger)]	= I(7),
			[B(NI_DI_SampleClock)]	= I(29),
			[B(NI_DO_SampleClock)]	= I(30),
			[B(NI_FrequencyOutput)]	= I(15),
			[B(NI_ChangeDetectionEvent)]	= I(28),
			[B(NI_AnalogComparisonEvent)]	= I(17),
			[B(NI_SCXI_Trig1)]	= I(27),
			[B(NI_ExternalStrobe)]	= I(11),
			[B(NI_PFI_DO)]	= I(16),
		},
		[B(NI_PFI(11))] = {
			[B(TRIGGER_LINE(0))]	= I(18),
			[B(TRIGGER_LINE(1))]	= I(19),
			[B(TRIGGER_LINE(2))]	= I(20),
			[B(TRIGGER_LINE(3))]	= I(21),
			[B(TRIGGER_LINE(4))]	= I(22),
			[B(TRIGGER_LINE(5))]	= I(23),
			[B(TRIGGER_LINE(6))]	= I(24),
			[B(TRIGGER_LINE(7))]	= I(25),
			[B(NI_CtrSource(0))]	= I(9),
			[B(NI_CtrSource(1))]	= I(4),
			[B(NI_CtrGate(0))]	= I(10),
			[B(NI_CtrGate(1))]	= I(5),
			[B(NI_CtrInternalOutput(0))]	= I(13),
			[B(NI_CtrInternalOutput(1))]	= I(14),
			[B(PXI_Star)]	= I(26),
			[B(NI_AI_SampleClock)]	= I(8),
			[B(NI_AI_StartTrigger)]	= I(1),
			[B(NI_AI_ReferenceTrigger)]	= I(2),
			[B(NI_AI_ConvertClock)]	= I(3),
			[B(NI_AI_ExternalMUXClock)]	= I(12),
			[B(NI_AO_SampleClock)]	= I(6),
			[B(NI_AO_StartTrigger)]	= I(7),
			[B(NI_DI_SampleClock)]	= I(29),
			[B(NI_DO_SampleClock)]	= I(30),
			[B(NI_FrequencyOutput)]	= I(15),
			[B(NI_ChangeDetectionEvent)]	= I(28),
			[B(NI_AnalogComparisonEvent)]	= I(17),
			[B(NI_SCXI_Trig1)]	= I(27),
			[B(NI_ExternalStrobe)]	= I(11),
			[B(NI_PFI_DO)]	= I(16),
		},
		[B(NI_PFI(12))] = {
			[B(TRIGGER_LINE(0))]	= I(18),
			[B(TRIGGER_LINE(1))]	= I(19),
			[B(TRIGGER_LINE(2))]	= I(20),
			[B(TRIGGER_LINE(3))]	= I(21),
			[B(TRIGGER_LINE(4))]	= I(22),
			[B(TRIGGER_LINE(5))]	= I(23),
			[B(TRIGGER_LINE(6))]	= I(24),
			[B(TRIGGER_LINE(7))]	= I(25),
			[B(NI_CtrSource(0))]	= I(9),
			[B(NI_CtrSource(1))]	= I(4),
			[B(NI_CtrGate(0))]	= I(10),
			[B(NI_CtrGate(1))]	= I(5),
			[B(NI_CtrInternalOutput(0))]	= I(13),
			[B(NI_CtrInternalOutput(1))]	= I(14),
			[B(PXI_Star)]	= I(26),
			[B(NI_AI_SampleClock)]	= I(8),
			[B(NI_AI_StartTrigger)]	= I(1),
			[B(NI_AI_ReferenceTrigger)]	= I(2),
			[B(NI_AI_ConvertClock)]	= I(3),
			[B(NI_AI_ExternalMUXClock)]	= I(12),
			[B(NI_AO_SampleClock)]	= I(6),
			[B(NI_AO_StartTrigger)]	= I(7),
			[B(NI_DI_SampleClock)]	= I(29),
			[B(NI_DO_SampleClock)]	= I(30),
			[B(NI_FrequencyOutput)]	= I(15),
			[B(NI_ChangeDetectionEvent)]	= I(28),
			[B(NI_AnalogComparisonEvent)]	= I(17),
			[B(NI_SCXI_Trig1)]	= I(27),
			[B(NI_ExternalStrobe)]	= I(11),
			[B(NI_PFI_DO)]	= I(16),
		},
		[B(NI_PFI(13))] = {
			[B(TRIGGER_LINE(0))]	= I(18),
			[B(TRIGGER_LINE(1))]	= I(19),
			[B(TRIGGER_LINE(2))]	= I(20),
			[B(TRIGGER_LINE(3))]	= I(21),
			[B(TRIGGER_LINE(4))]	= I(22),
			[B(TRIGGER_LINE(5))]	= I(23),
			[B(TRIGGER_LINE(6))]	= I(24),
			[B(TRIGGER_LINE(7))]	= I(25),
			[B(NI_CtrSource(0))]	= I(9),
			[B(NI_CtrSource(1))]	= I(4),
			[B(NI_CtrGate(0))]	= I(10),
			[B(NI_CtrGate(1))]	= I(5),
			[B(NI_CtrInternalOutput(0))]	= I(13),
			[B(NI_CtrInternalOutput(1))]	= I(14),
			[B(PXI_Star)]	= I(26),
			[B(NI_AI_SampleClock)]	= I(8),
			[B(NI_AI_StartTrigger)]	= I(1),
			[B(NI_AI_ReferenceTrigger)]	= I(2),
			[B(NI_AI_ConvertClock)]	= I(3),
			[B(NI_AI_ExternalMUXClock)]	= I(12),
			[B(NI_AO_SampleClock)]	= I(6),
			[B(NI_AO_StartTrigger)]	= I(7),
			[B(NI_DI_SampleClock)]	= I(29),
			[B(NI_DO_SampleClock)]	= I(30),
			[B(NI_FrequencyOutput)]	= I(15),
			[B(NI_ChangeDetectionEvent)]	= I(28),
			[B(NI_AnalogComparisonEvent)]	= I(17),
			[B(NI_SCXI_Trig1)]	= I(27),
			[B(NI_ExternalStrobe)]	= I(11),
			[B(NI_PFI_DO)]	= I(16),
		},
		[B(NI_PFI(14))] = {
			[B(TRIGGER_LINE(0))]	= I(18),
			[B(TRIGGER_LINE(1))]	= I(19),
			[B(TRIGGER_LINE(2))]	= I(20),
			[B(TRIGGER_LINE(3))]	= I(21),
			[B(TRIGGER_LINE(4))]	= I(22),
			[B(TRIGGER_LINE(5))]	= I(23),
			[B(TRIGGER_LINE(6))]	= I(24),
			[B(TRIGGER_LINE(7))]	= I(25),
			[B(NI_CtrSource(0))]	= I(9),
			[B(NI_CtrSource(1))]	= I(4),
			[B(NI_CtrGate(0))]	= I(10),
			[B(NI_CtrGate(1))]	= I(5),
			[B(NI_CtrInternalOutput(0))]	= I(13),
			[B(NI_CtrInternalOutput(1))]	= I(14),
			[B(PXI_Star)]	= I(26),
			[B(NI_AI_SampleClock)]	= I(8),
			[B(NI_AI_StartTrigger)]	= I(1),
			[B(NI_AI_ReferenceTrigger)]	= I(2),
			[B(NI_AI_ConvertClock)]	= I(3),
			[B(NI_AI_ExternalMUXClock)]	= I(12),
			[B(NI_AO_SampleClock)]	= I(6),
			[B(NI_AO_StartTrigger)]	= I(7),
			[B(NI_DI_SampleClock)]	= I(29),
			[B(NI_DO_SampleClock)]	= I(30),
			[B(NI_FrequencyOutput)]	= I(15),
			[B(NI_ChangeDetectionEvent)]	= I(28),
			[B(NI_AnalogComparisonEvent)]	= I(17),
			[B(NI_SCXI_Trig1)]	= I(27),
			[B(NI_ExternalStrobe)]	= I(11),
			[B(NI_PFI_DO)]	= I(16),
		},
		[B(NI_PFI(15))] = {
			[B(TRIGGER_LINE(0))]	= I(18),
			[B(TRIGGER_LINE(1))]	= I(19),
			[B(TRIGGER_LINE(2))]	= I(20),
			[B(TRIGGER_LINE(3))]	= I(21),
			[B(TRIGGER_LINE(4))]	= I(22),
			[B(TRIGGER_LINE(5))]	= I(23),
			[B(TRIGGER_LINE(6))]	= I(24),
			[B(TRIGGER_LINE(7))]	= I(25),
			[B(NI_CtrSource(0))]	= I(9),
			[B(NI_CtrSource(1))]	= I(4),
			[B(NI_CtrGate(0))]	= I(10),
			[B(NI_CtrGate(1))]	= I(5),
			[B(NI_CtrInternalOutput(0))]	= I(13),
			[B(NI_CtrInternalOutput(1))]	= I(14),
			[B(PXI_Star)]	= I(26),
			[B(NI_AI_SampleClock)]	= I(8),
			[B(NI_AI_StartTrigger)]	= I(1),
			[B(NI_AI_ReferenceTrigger)]	= I(2),
			[B(NI_AI_ConvertClock)]	= I(3),
			[B(NI_AI_ExternalMUXClock)]	= I(12),
			[B(NI_AO_SampleClock)]	= I(6),
			[B(NI_AO_StartTrigger)]	= I(7),
			[B(NI_DI_SampleClock)]	= I(29),
			[B(NI_DO_SampleClock)]	= I(30),
			[B(NI_FrequencyOutput)]	= I(15),
			[B(NI_ChangeDetectionEvent)]	= I(28),
			[B(NI_AnalogComparisonEvent)]	= I(17),
			[B(NI_SCXI_Trig1)]	= I(27),
			[B(NI_ExternalStrobe)]	= I(11),
			[B(NI_PFI_DO)]	= I(16),
		},
		[B(TRIGGER_LINE(0))] = {
			[B(NI_RTSI_BRD(0))]	= I(8),
			[B(NI_RTSI_BRD(1))]	= I(9),
			[B(NI_RTSI_BRD(2))]	= I(10),
			[B(NI_RTSI_BRD(3))]	= I(11),
			[B(NI_CtrSource(0))]	= I(5),
			[B(NI_CtrGate(0))]	= I(6),
			[B(NI_AI_StartTrigger)]	= I(0),
			[B(NI_AI_ReferenceTrigger)]	= I(1),
			[B(NI_AI_ConvertClock)]	= I(2),
			[B(NI_AO_SampleClock)]	= I(3),
			[B(NI_AO_StartTrigger)]	= I(4),
			/*
			 * for (*->TRIGGER_LINE(*)) MUX, a value of 12 should be
			 * RTSI_OSC according to MHDDK mseries source.  There
			 * are hints in comedi that show that this is actually a
			 * 20MHz source for 628x cards(?)
			 */
			[B(NI_10MHzRefClock)]	= I(12),
			[B(NI_RGOUT0)]	= I(7),
		},
		[B(TRIGGER_LINE(1))] = {
			[B(NI_RTSI_BRD(0))]	= I(8),
			[B(NI_RTSI_BRD(1))]	= I(9),
			[B(NI_RTSI_BRD(2))]	= I(10),
			[B(NI_RTSI_BRD(3))]	= I(11),
			[B(NI_CtrSource(0))]	= I(5),
			[B(NI_CtrGate(0))]	= I(6),
			[B(NI_AI_StartTrigger)]	= I(0),
			[B(NI_AI_ReferenceTrigger)]	= I(1),
			[B(NI_AI_ConvertClock)]	= I(2),
			[B(NI_AO_SampleClock)]	= I(3),
			[B(NI_AO_StartTrigger)]	= I(4),
			/*
			 * for (*->TRIGGER_LINE(*)) MUX, a value of 12 should be
			 * RTSI_OSC according to MHDDK mseries source.  There
			 * are hints in comedi that show that this is actually a
			 * 20MHz source for 628x cards(?)
			 */
			[B(NI_10MHzRefClock)]	= I(12),
			[B(NI_RGOUT0)]	= I(7),
		},
		[B(TRIGGER_LINE(2))] = {
			[B(NI_RTSI_BRD(0))]	= I(8),
			[B(NI_RTSI_BRD(1))]	= I(9),
			[B(NI_RTSI_BRD(2))]	= I(10),
			[B(NI_RTSI_BRD(3))]	= I(11),
			[B(NI_CtrSource(0))]	= I(5),
			[B(NI_CtrGate(0))]	= I(6),
			[B(NI_AI_StartTrigger)]	= I(0),
			[B(NI_AI_ReferenceTrigger)]	= I(1),
			[B(NI_AI_ConvertClock)]	= I(2),
			[B(NI_AO_SampleClock)]	= I(3),
			[B(NI_AO_StartTrigger)]	= I(4),
			/*
			 * for (*->TRIGGER_LINE(*)) MUX, a value of 12 should be
			 * RTSI_OSC according to MHDDK mseries source.  There
			 * are hints in comedi that show that this is actually a
			 * 20MHz source for 628x cards(?)
			 */
			[B(NI_10MHzRefClock)]	= I(12),
			[B(NI_RGOUT0)]	= I(7),
		},
		[B(TRIGGER_LINE(3))] = {
			[B(NI_RTSI_BRD(0))]	= I(8),
			[B(NI_RTSI_BRD(1))]	= I(9),
			[B(NI_RTSI_BRD(2))]	= I(10),
			[B(NI_RTSI_BRD(3))]	= I(11),
			[B(NI_CtrSource(0))]	= I(5),
			[B(NI_CtrGate(0))]	= I(6),
			[B(NI_AI_StartTrigger)]	= I(0),
			[B(NI_AI_ReferenceTrigger)]	= I(1),
			[B(NI_AI_ConvertClock)]	= I(2),
			[B(NI_AO_SampleClock)]	= I(3),
			[B(NI_AO_StartTrigger)]	= I(4),
			/*
			 * for (*->TRIGGER_LINE(*)) MUX, a value of 12 should be
			 * RTSI_OSC according to MHDDK mseries source.  There
			 * are hints in comedi that show that this is actually a
			 * 20MHz source for 628x cards(?)
			 */
			[B(NI_10MHzRefClock)]	= I(12),
			[B(NI_RGOUT0)]	= I(7),
		},
		[B(TRIGGER_LINE(4))] = {
			[B(NI_RTSI_BRD(0))]	= I(8),
			[B(NI_RTSI_BRD(1))]	= I(9),
			[B(NI_RTSI_BRD(2))]	= I(10),
			[B(NI_RTSI_BRD(3))]	= I(11),
			[B(NI_CtrSource(0))]	= I(5),
			[B(NI_CtrGate(0))]	= I(6),
			[B(NI_AI_StartTrigger)]	= I(0),
			[B(NI_AI_ReferenceTrigger)]	= I(1),
			[B(NI_AI_ConvertClock)]	= I(2),
			[B(NI_AO_SampleClock)]	= I(3),
			[B(NI_AO_StartTrigger)]	= I(4),
			/*
			 * for (*->TRIGGER_LINE(*)) MUX, a value of 12 should be
			 * RTSI_OSC according to MHDDK mseries source.  There
			 * are hints in comedi that show that this is actually a
			 * 20MHz source for 628x cards(?)
			 */
			[B(NI_10MHzRefClock)]	= I(12),
			[B(NI_RGOUT0)]	= I(7),
		},
		[B(TRIGGER_LINE(5))] = {
			[B(NI_RTSI_BRD(0))]	= I(8),
			[B(NI_RTSI_BRD(1))]	= I(9),
			[B(NI_RTSI_BRD(2))]	= I(10),
			[B(NI_RTSI_BRD(3))]	= I(11),
			[B(NI_CtrSource(0))]	= I(5),
			[B(NI_CtrGate(0))]	= I(6),
			[B(NI_AI_StartTrigger)]	= I(0),
			[B(NI_AI_ReferenceTrigger)]	= I(1),
			[B(NI_AI_ConvertClock)]	= I(2),
			[B(NI_AO_SampleClock)]	= I(3),
			[B(NI_AO_StartTrigger)]	= I(4),
			/*
			 * for (*->TRIGGER_LINE(*)) MUX, a value of 12 should be
			 * RTSI_OSC according to MHDDK mseries source.  There
			 * are hints in comedi that show that this is actually a
			 * 20MHz source for 628x cards(?)
			 */
			[B(NI_10MHzRefClock)]	= I(12),
			[B(NI_RGOUT0)]	= I(7),
		},
		[B(TRIGGER_LINE(6))] = {
			[B(NI_RTSI_BRD(0))]	= I(8),
			[B(NI_RTSI_BRD(1))]	= I(9),
			[B(NI_RTSI_BRD(2))]	= I(10),
			[B(NI_RTSI_BRD(3))]	= I(11),
			[B(NI_CtrSource(0))]	= I(5),
			[B(NI_CtrGate(0))]	= I(6),
			[B(NI_AI_StartTrigger)]	= I(0),
			[B(NI_AI_ReferenceTrigger)]	= I(1),
			[B(NI_AI_ConvertClock)]	= I(2),
			[B(NI_AO_SampleClock)]	= I(3),
			[B(NI_AO_StartTrigger)]	= I(4),
			/*
			 * for (*->TRIGGER_LINE(*)) MUX, a value of 12 should be
			 * RTSI_OSC according to MHDDK mseries source.  There
			 * are hints in comedi that show that this is actually a
			 * 20MHz source for 628x cards(?)
			 */
			[B(NI_10MHzRefClock)]	= I(12),
			[B(NI_RGOUT0)]	= I(7),
		},
		[B(TRIGGER_LINE(7))] = {
			[B(NI_RTSI_BRD(0))]	= I(8),
			[B(NI_RTSI_BRD(1))]	= I(9),
			[B(NI_RTSI_BRD(2))]	= I(10),
			[B(NI_RTSI_BRD(3))]	= I(11),
			[B(NI_CtrSource(0))]	= I(5),
			[B(NI_CtrGate(0))]	= I(6),
			[B(NI_AI_StartTrigger)]	= I(0),
			[B(NI_AI_ReferenceTrigger)]	= I(1),
			[B(NI_AI_ConvertClock)]	= I(2),
			[B(NI_AO_SampleClock)]	= I(3),
			[B(NI_AO_StartTrigger)]	= I(4),
			/*
			 * for (*->TRIGGER_LINE(*)) MUX, a value of 12 should be
			 * RTSI_OSC according to MHDDK mseries source.  There
			 * are hints in comedi that show that this is actually a
			 * 20MHz source for 628x cards(?)
			 */
			[B(NI_10MHzRefClock)]	= I(12),
			[B(NI_RGOUT0)]	= I(7),
		},
		[B(NI_RTSI_BRD(0))] = {
			[B(NI_PFI(0))]	= I(0),
			[B(NI_PFI(1))]	= I(1),
			[B(NI_PFI(2))]	= I(2),
			[B(NI_PFI(3))]	= I(3),
			[B(NI_PFI(4))]	= I(4),
			[B(NI_PFI(5))]	= I(5),
			[B(NI_CtrSource(1))]	= I(11),
			[B(NI_CtrGate(1))]	= I(10),
			[B(NI_CtrZ(0))]	= I(13),
			[B(NI_CtrZ(1))]	= I(12),
			[B(NI_CtrOut(1))]	= I(9),
			[B(NI_AI_SampleClock)]	= I(15),
			[B(NI_AI_PauseTrigger)]	= I(7),
			[B(NI_AO_PauseTrigger)]	= I(6),
			[B(NI_FrequencyOutput)]	= I(8),
			[B(NI_AnalogComparisonEvent)]	= I(14),
		},
		[B(NI_RTSI_BRD(1))] = {
			[B(NI_PFI(0))]	= I(0),
			[B(NI_PFI(1))]	= I(1),
			[B(NI_PFI(2))]	= I(2),
			[B(NI_PFI(3))]	= I(3),
			[B(NI_PFI(4))]	= I(4),
			[B(NI_PFI(5))]	= I(5),
			[B(NI_CtrSource(1))]	= I(11),
			[B(NI_CtrGate(1))]	= I(10),
			[B(NI_CtrZ(0))]	= I(13),
			[B(NI_CtrZ(1))]	= I(12),
			[B(NI_CtrOut(1))]	= I(9),
			[B(NI_AI_SampleClock)]	= I(15),
			[B(NI_AI_PauseTrigger)]	= I(7),
			[B(NI_AO_PauseTrigger)]	= I(6),
			[B(NI_FrequencyOutput)]	= I(8),
			[B(NI_AnalogComparisonEvent)]	= I(14),
		},
		[B(NI_RTSI_BRD(2))] = {
			[B(NI_PFI(0))]	= I(0),
			[B(NI_PFI(1))]	= I(1),
			[B(NI_PFI(2))]	= I(2),
			[B(NI_PFI(3))]	= I(3),
			[B(NI_PFI(4))]	= I(4),
			[B(NI_PFI(5))]	= I(5),
			[B(NI_CtrSource(1))]	= I(11),
			[B(NI_CtrGate(1))]	= I(10),
			[B(NI_CtrZ(0))]	= I(13),
			[B(NI_CtrZ(1))]	= I(12),
			[B(NI_CtrOut(1))]	= I(9),
			[B(NI_AI_SampleClock)]	= I(15),
			[B(NI_AI_PauseTrigger)]	= I(7),
			[B(NI_AO_PauseTrigger)]	= I(6),
			[B(NI_FrequencyOutput)]	= I(8),
			[B(NI_AnalogComparisonEvent)]	= I(14),
		},
		[B(NI_RTSI_BRD(3))] = {
			[B(NI_PFI(0))]	= I(0),
			[B(NI_PFI(1))]	= I(1),
			[B(NI_PFI(2))]	= I(2),
			[B(NI_PFI(3))]	= I(3),
			[B(NI_PFI(4))]	= I(4),
			[B(NI_PFI(5))]	= I(5),
			[B(NI_CtrSource(1))]	= I(11),
			[B(NI_CtrGate(1))]	= I(10),
			[B(NI_CtrZ(0))]	= I(13),
			[B(NI_CtrZ(1))]	= I(12),
			[B(NI_CtrOut(1))]	= I(9),
			[B(NI_AI_SampleClock)]	= I(15),
			[B(NI_AI_PauseTrigger)]	= I(7),
			[B(NI_AO_PauseTrigger)]	= I(6),
			[B(NI_FrequencyOutput)]	= I(8),
			[B(NI_AnalogComparisonEvent)]	= I(14),
		},
		[B(NI_CtrSource(0))] = {
			/* These are not currently implemented in ni modules */
			[B(NI_PFI(0))]	= U(1),
			[B(NI_PFI(1))]	= U(2),
			[B(NI_PFI(2))]	= U(3),
			[B(NI_PFI(3))]	= U(4),
			[B(NI_PFI(4))]	= U(5),
			[B(NI_PFI(5))]	= U(6),
			[B(NI_PFI(6))]	= U(7),
			[B(NI_PFI(7))]	= U(8),
			[B(NI_PFI(8))]	= U(9),
			[B(NI_PFI(9))]	= U(10),
			[B(NI_PFI(10))]	= U(21),
			[B(NI_PFI(11))]	= U(22),
			[B(NI_PFI(12))]	= U(23),
			[B(NI_PFI(13))]	= U(24),
			[B(NI_PFI(14))]	= U(25),
			[B(NI_PFI(15))]	= U(26),
			[B(TRIGGER_LINE(0))]	= U(11),
			[B(TRIGGER_LINE(1))]	= U(12),
			[B(TRIGGER_LINE(2))]	= U(13),
			[B(TRIGGER_LINE(3))]	= U(14),
			[B(TRIGGER_LINE(4))]	= U(15),
			[B(TRIGGER_LINE(5))]	= U(16),
			[B(TRIGGER_LINE(6))]	= U(17),
			[B(TRIGGER_LINE(7))]	= U(27),
			[B(NI_CtrGate(1))]	= U(Gi_SRC(20, 0)),
			[B(NI_CtrInternalOutput(1))]	= U(19),
			[B(PXI_Star)]	= U(Gi_SRC(20, 1)),
			[B(PXI_Clk10)]	= U(29),
			[B(NI_20MHzTimebase)]	= U(0),
			[B(NI_80MHzTimebase)]	= U(Gi_SRC(30, 0)),
			[B(NI_100kHzTimebase)]	= U(18),
			[B(NI_AnalogComparisonEvent)]	= U(Gi_SRC(30, 1)),
			[B(NI_LogicLow)]	= U(31),
		},
		[B(NI_CtrSource(1))] = {
			/* These are not currently implemented in ni modules */
			[B(NI_PFI(0))]	= U(1),
			[B(NI_PFI(1))]	= U(2),
			[B(NI_PFI(2))]	= U(3),
			[B(NI_PFI(3))]	= U(4),
			[B(NI_PFI(4))]	= U(5),
			[B(NI_PFI(5))]	= U(6),
			[B(NI_PFI(6))]	= U(7),
			[B(NI_PFI(7))]	= U(8),
			[B(NI_PFI(8))]	= U(9),
			[B(NI_PFI(9))]	= U(10),
			[B(NI_PFI(10))]	= U(21),
			[B(NI_PFI(11))]	= U(22),
			[B(NI_PFI(12))]	= U(23),
			[B(NI_PFI(13))]	= U(24),
			[B(NI_PFI(14))]	= U(25),
			[B(NI_PFI(15))]	= U(26),
			[B(TRIGGER_LINE(0))]	= U(11),
			[B(TRIGGER_LINE(1))]	= U(12),
			[B(TRIGGER_LINE(2))]	= U(13),
			[B(TRIGGER_LINE(3))]	= U(14),
			[B(TRIGGER_LINE(4))]	= U(15),
			[B(TRIGGER_LINE(5))]	= U(16),
			[B(TRIGGER_LINE(6))]	= U(17),
			[B(TRIGGER_LINE(7))]	= U(27),
			[B(NI_CtrGate(0))]	= U(Gi_SRC(20, 0)),
			[B(NI_CtrInternalOutput(0))]	= U(19),
			[B(PXI_Star)]	= U(Gi_SRC(20, 1)),
			[B(PXI_Clk10)]	= U(29),
			[B(NI_20MHzTimebase)]	= U(0),
			[B(NI_80MHzTimebase)]	= U(Gi_SRC(30, 0)),
			[B(NI_100kHzTimebase)]	= U(18),
			[B(NI_AnalogComparisonEvent)]	= U(Gi_SRC(30, 1)),
			[B(NI_LogicLow)]	= U(31),
		},
		[B(NI_CtrGate(0))] = {
			[B(NI_PFI(0))]	= I(1 /* source:  mhddk examples */),
			[B(NI_PFI(1))]	= I(2),
			[B(NI_PFI(2))]	= I(3),
			[B(NI_PFI(3))]	= I(4),
			[B(NI_PFI(4))]	= I(5),
			[B(NI_PFI(5))]	= I(6),
			[B(NI_PFI(6))]	= I(7),
			[B(NI_PFI(7))]	= I(8),
			[B(NI_PFI(8))]	= I(9),
			[B(NI_PFI(9))]	= I(10),
			[B(NI_PFI(10))]	= I(21),
			[B(NI_PFI(11))]	= I(22),
			[B(NI_PFI(12))]	= I(23),
			[B(NI_PFI(13))]	= I(24),
			[B(NI_PFI(14))]	= I(25),
			[B(NI_PFI(15))]	= I(26),
			[B(TRIGGER_LINE(0))]	= I(11),
			[B(TRIGGER_LINE(1))]	= I(12),
			[B(TRIGGER_LINE(2))]	= I(13),
			[B(TRIGGER_LINE(3))]	= I(14),
			[B(TRIGGER_LINE(4))]	= I(15),
			[B(TRIGGER_LINE(5))]	= I(16),
			[B(TRIGGER_LINE(6))]	= I(17),
			[B(TRIGGER_LINE(7))]	= I(27),
			[B(NI_CtrSource(1))]	= I(29),
			/* source for following line:  mhddk GP examples */
			[B(NI_CtrInternalOutput(1))]	= I(20),
			[B(PXI_Star)]	= I(19),
			[B(NI_AI_StartTrigger)]	= I(28),
			[B(NI_AI_ReferenceTrigger)]	= I(18),
			[B(NI_AnalogComparisonEvent)]	= I(30),
			[B(NI_LogicLow)]	= I(31),
		},
		[B(NI_CtrGate(1))] = {
			/* source for following line:  mhddk examples */
			[B(NI_PFI(0))]	= I(1),
			[B(NI_PFI(1))]	= I(2),
			[B(NI_PFI(2))]	= I(3),
			[B(NI_PFI(3))]	= I(4),
			[B(NI_PFI(4))]	= I(5),
			[B(NI_PFI(5))]	= I(6),
			[B(NI_PFI(6))]	= I(7),
			[B(NI_PFI(7))]	= I(8),
			[B(NI_PFI(8))]	= I(9),
			[B(NI_PFI(9))]	= I(10),
			[B(NI_PFI(10))]	= I(21),
			[B(NI_PFI(11))]	= I(22),
			[B(NI_PFI(12))]	= I(23),
			[B(NI_PFI(13))]	= I(24),
			[B(NI_PFI(14))]	= I(25),
			[B(NI_PFI(15))]	= I(26),
			[B(TRIGGER_LINE(0))]	= I(11),
			[B(TRIGGER_LINE(1))]	= I(12),
			[B(TRIGGER_LINE(2))]	= I(13),
			[B(TRIGGER_LINE(3))]	= I(14),
			[B(TRIGGER_LINE(4))]	= I(15),
			[B(TRIGGER_LINE(5))]	= I(16),
			[B(TRIGGER_LINE(6))]	= I(17),
			[B(TRIGGER_LINE(7))]	= I(27),
			[B(NI_CtrSource(0))]	= I(29),
			/* source for following line:  mhddk GP examples */
			[B(NI_CtrInternalOutput(0))]	= I(20),
			[B(PXI_Star)]	= I(19),
			[B(NI_AI_StartTrigger)]	= I(28),
			[B(NI_AI_ReferenceTrigger)]	= I(18),
			[B(NI_AnalogComparisonEvent)]	= I(30),
			[B(NI_LogicLow)]	= I(31),
		},
		[B(NI_CtrAux(0))] = {
			/* these are just a guess; see GATE SELECT NOTE */
			[B(NI_PFI(0))]	= I(1),
			[B(NI_PFI(1))]	= I(2),
			[B(NI_PFI(2))]	= I(3),
			[B(NI_PFI(3))]	= I(4),
			[B(NI_PFI(4))]	= I(5),
			[B(NI_PFI(5))]	= I(6),
			[B(NI_PFI(6))]	= I(7),
			[B(NI_PFI(7))]	= I(8),
			[B(NI_PFI(8))]	= I(9),
			[B(NI_PFI(9))]	= I(10),
			[B(NI_PFI(10))]	= I(21),
			[B(NI_PFI(11))]	= I(22),
			[B(NI_PFI(12))]	= I(23),
			[B(NI_PFI(13))]	= I(24),
			[B(NI_PFI(14))]	= I(25),
			[B(NI_PFI(15))]	= I(26),
			[B(TRIGGER_LINE(0))]	= I(11),
			[B(TRIGGER_LINE(1))]	= I(12),
			[B(TRIGGER_LINE(2))]	= I(13),
			[B(TRIGGER_LINE(3))]	= I(14),
			[B(TRIGGER_LINE(4))]	= I(15),
			[B(TRIGGER_LINE(5))]	= I(16),
			[B(TRIGGER_LINE(6))]	= I(17),
			[B(TRIGGER_LINE(7))]	= I(27),
			[B(NI_CtrSource(1))]	= I(29),
			/* source for following line:  mhddk GP examples */
			[B(NI_CtrInternalOutput(1))]	= I(20),
			[B(PXI_Star)]	= I(19),
			[B(NI_AI_StartTrigger)]	= I(28),
			[B(NI_AI_ReferenceTrigger)]	= I(18),
			[B(NI_AnalogComparisonEvent)]	= I(30),
			[B(NI_LogicLow)]	= I(31),
		},
		[B(NI_CtrAux(1))] = {
			/* these are just a guess; see GATE SELECT NOTE */
			[B(NI_PFI(0))]	= I(1),
			[B(NI_PFI(1))]	= I(2),
			[B(NI_PFI(2))]	= I(3),
			[B(NI_PFI(3))]	= I(4),
			[B(NI_PFI(4))]	= I(5),
			[B(NI_PFI(5))]	= I(6),
			[B(NI_PFI(6))]	= I(7),
			[B(NI_PFI(7))]	= I(8),
			[B(NI_PFI(8))]	= I(9),
			[B(NI_PFI(9))]	= I(10),
			[B(NI_PFI(10))]	= I(21),
			[B(NI_PFI(11))]	= I(22),
			[B(NI_PFI(12))]	= I(23),
			[B(NI_PFI(13))]	= I(24),
			[B(NI_PFI(14))]	= I(25),
			[B(NI_PFI(15))]	= I(26),
			[B(TRIGGER_LINE(0))]	= I(11),
			[B(TRIGGER_LINE(1))]	= I(12),
			[B(TRIGGER_LINE(2))]	= I(13),
			[B(TRIGGER_LINE(3))]	= I(14),
			[B(TRIGGER_LINE(4))]	= I(15),
			[B(TRIGGER_LINE(5))]	= I(16),
			[B(TRIGGER_LINE(6))]	= I(17),
			[B(TRIGGER_LINE(7))]	= I(27),
			[B(NI_CtrSource(0))]	= I(29),
			/* source for following line:  mhddk GP examples */
			[B(NI_CtrInternalOutput(0))]	= I(20),
			[B(PXI_Star)]	= I(19),
			[B(NI_AI_StartTrigger)]	= I(28),
			[B(NI_AI_ReferenceTrigger)]	= I(18),
			[B(NI_AnalogComparisonEvent)]	= I(30),
			[B(NI_LogicLow)]	= I(31),
		},
		[B(NI_CtrA(0))] = {
			/*
			 * See nimseries/Examples for outputs; inputs a guess
			 * from device routes shown on NI-MAX.
			 * see M-Series user manual (371022K-01)
			 */
			[B(NI_PFI(0))]	= I(1),
			[B(NI_PFI(1))]	= I(2),
			[B(NI_PFI(2))]	= I(3),
			[B(NI_PFI(3))]	= I(4),
			[B(NI_PFI(4))]	= I(5),
			[B(NI_PFI(5))]	= I(6),
			[B(NI_PFI(6))]	= I(7),
			[B(NI_PFI(7))]	= I(8),
			[B(NI_PFI(8))]	= I(9),
			[B(NI_PFI(9))]	= I(10),
			[B(NI_PFI(10))]	= I(21),
			[B(NI_PFI(11))]	= I(22),
			[B(NI_PFI(12))]	= I(23),
			[B(NI_PFI(13))]	= I(24),
			[B(NI_PFI(14))]	= I(25),
			[B(NI_PFI(15))]	= I(26),
			[B(TRIGGER_LINE(0))]	= I(11),
			[B(TRIGGER_LINE(1))]	= I(12),
			[B(TRIGGER_LINE(2))]	= I(13),
			[B(TRIGGER_LINE(3))]	= I(14),
			[B(TRIGGER_LINE(4))]	= I(15),
			[B(TRIGGER_LINE(5))]	= I(16),
			[B(TRIGGER_LINE(6))]	= I(17),
			[B(TRIGGER_LINE(7))]	= I(27),
			[B(PXI_Star)]	= I(20),
			[B(NI_AnalogComparisonEvent)]	= I(30),
			[B(NI_LogicLow)]	= I(31),
		},
		[B(NI_CtrA(1))] = {
			/*
			 * See nimseries/Examples for outputs; inputs a guess
			 * from device routes shown on NI-MAX.
			 * see M-Series user manual (371022K-01)
			 */
			[B(NI_PFI(0))]	= I(1),
			[B(NI_PFI(1))]	= I(2),
			[B(NI_PFI(2))]	= I(3),
			[B(NI_PFI(3))]	= I(4),
			[B(NI_PFI(4))]	= I(5),
			[B(NI_PFI(5))]	= I(6),
			[B(NI_PFI(6))]	= I(7),
			[B(NI_PFI(7))]	= I(8),
			[B(NI_PFI(8))]	= I(9),
			[B(NI_PFI(9))]	= I(10),
			[B(NI_PFI(10))]	= I(21),
			[B(NI_PFI(11))]	= I(22),
			[B(NI_PFI(12))]	= I(23),
			[B(NI_PFI(13))]	= I(24),
			[B(NI_PFI(14))]	= I(25),
			[B(NI_PFI(15))]	= I(26),
			[B(TRIGGER_LINE(0))]	= I(11),
			[B(TRIGGER_LINE(1))]	= I(12),
			[B(TRIGGER_LINE(2))]	= I(13),
			[B(TRIGGER_LINE(3))]	= I(14),
			[B(TRIGGER_LINE(4))]	= I(15),
			[B(TRIGGER_LINE(5))]	= I(16),
			[B(TRIGGER_LINE(6))]	= I(17),
			[B(TRIGGER_LINE(7))]	= I(27),
			[B(PXI_Star)]	= I(20),
			[B(NI_AnalogComparisonEvent)]	= I(30),
			[B(NI_LogicLow)]	= I(31),
		},
		[B(NI_CtrB(0))] = {
			/*
			 * See nimseries/Examples for outputs; inputs a guess
			 * from device routes shown on NI-MAX.
			 * see M-Series user manual (371022K-01)
			 */
			[B(NI_PFI(0))]	= I(1),
			[B(NI_PFI(1))]	= I(2),
			[B(NI_PFI(2))]	= I(3),
			[B(NI_PFI(3))]	= I(4),
			[B(NI_PFI(4))]	= I(5),
			[B(NI_PFI(5))]	= I(6),
			[B(NI_PFI(6))]	= I(7),
			[B(NI_PFI(7))]	= I(8),
			[B(NI_PFI(8))]	= I(9),
			[B(NI_PFI(9))]	= I(10),
			[B(NI_PFI(10))]	= I(21),
			[B(NI_PFI(11))]	= I(22),
			[B(NI_PFI(12))]	= I(23),
			[B(NI_PFI(13))]	= I(24),
			[B(NI_PFI(14))]	= I(25),
			[B(NI_PFI(15))]	= I(26),
			[B(TRIGGER_LINE(0))]	= I(11),
			[B(TRIGGER_LINE(1))]	= I(12),
			[B(TRIGGER_LINE(2))]	= I(13),
			[B(TRIGGER_LINE(3))]	= I(14),
			[B(TRIGGER_LINE(4))]	= I(15),
			[B(TRIGGER_LINE(5))]	= I(16),
			[B(TRIGGER_LINE(6))]	= I(17),
			[B(TRIGGER_LINE(7))]	= I(27),
			[B(PXI_Star)]	= I(20),
			[B(NI_AnalogComparisonEvent)]	= I(30),
			[B(NI_LogicLow)]	= I(31),
		},
		[B(NI_CtrB(1))] = {
			/*
			 * See nimseries/Examples for outputs; inputs a guess
			 * from device routes shown on NI-MAX.
			 * see M-Series user manual (371022K-01)
			 */
			[B(NI_PFI(0))]	= I(1),
			[B(NI_PFI(1))]	= I(2),
			[B(NI_PFI(2))]	= I(3),
			[B(NI_PFI(3))]	= I(4),
			[B(NI_PFI(4))]	= I(5),
			[B(NI_PFI(5))]	= I(6),
			[B(NI_PFI(6))]	= I(7),
			[B(NI_PFI(7))]	= I(8),
			[B(NI_PFI(8))]	= I(9),
			[B(NI_PFI(9))]	= I(10),
			[B(NI_PFI(10))]	= I(21),
			[B(NI_PFI(11))]	= I(22),
			[B(NI_PFI(12))]	= I(23),
			[B(NI_PFI(13))]	= I(24),
			[B(NI_PFI(14))]	= I(25),
			[B(NI_PFI(15))]	= I(26),
			[B(TRIGGER_LINE(0))]	= I(11),
			[B(TRIGGER_LINE(1))]	= I(12),
			[B(TRIGGER_LINE(2))]	= I(13),
			[B(TRIGGER_LINE(3))]	= I(14),
			[B(TRIGGER_LINE(4))]	= I(15),
			[B(TRIGGER_LINE(5))]	= I(16),
			[B(TRIGGER_LINE(6))]	= I(17),
			[B(TRIGGER_LINE(7))]	= I(27),
			[B(PXI_Star)]	= I(20),
			[B(NI_AnalogComparisonEvent)]	= I(30),
			[B(NI_LogicLow)]	= I(31),
		},
		[B(NI_CtrZ(0))] = {
			/*
			 * See nimseries/Examples for outputs; inputs a guess
			 * from device routes shown on NI-MAX.
			 * see M-Series user manual (371022K-01)
			 */
			[B(NI_PFI(0))]	= I(1),
			[B(NI_PFI(1))]	= I(2),
			[B(NI_PFI(2))]	= I(3),
			[B(NI_PFI(3))]	= I(4),
			[B(NI_PFI(4))]	= I(5),
			[B(NI_PFI(5))]	= I(6),
			[B(NI_PFI(6))]	= I(7),
			[B(NI_PFI(7))]	= I(8),
			[B(NI_PFI(8))]	= I(9),
			[B(NI_PFI(9))]	= I(10),
			[B(NI_PFI(10))]	= I(21),
			[B(NI_PFI(11))]	= I(22),
			[B(NI_PFI(12))]	= I(23),
			[B(NI_PFI(13))]	= I(24),
			[B(NI_PFI(14))]	= I(25),
			[B(NI_PFI(15))]	= I(26),
			[B(TRIGGER_LINE(0))]	= I(11),
			[B(TRIGGER_LINE(1))]	= I(12),
			[B(TRIGGER_LINE(2))]	= I(13),
			[B(TRIGGER_LINE(3))]	= I(14),
			[B(TRIGGER_LINE(4))]	= I(15),
			[B(TRIGGER_LINE(5))]	= I(16),
			[B(TRIGGER_LINE(6))]	= I(17),
			[B(TRIGGER_LINE(7))]	= I(27),
			[B(PXI_Star)]	= I(20),
			[B(NI_AnalogComparisonEvent)]	= I(30),
			[B(NI_LogicLow)]	= I(31),
		},
		[B(NI_CtrZ(1))] = {
			/*
			 * See nimseries/Examples for outputs; inputs a guess
			 * from device routes shown on NI-MAX.
			 * see M-Series user manual (371022K-01)
			 */
			[B(NI_PFI(0))]	= I(1),
			[B(NI_PFI(1))]	= I(2),
			[B(NI_PFI(2))]	= I(3),
			[B(NI_PFI(3))]	= I(4),
			[B(NI_PFI(4))]	= I(5),
			[B(NI_PFI(5))]	= I(6),
			[B(NI_PFI(6))]	= I(7),
			[B(NI_PFI(7))]	= I(8),
			[B(NI_PFI(8))]	= I(9),
			[B(NI_PFI(9))]	= I(10),
			[B(NI_PFI(10))]	= I(21),
			[B(NI_PFI(11))]	= I(22),
			[B(NI_PFI(12))]	= I(23),
			[B(NI_PFI(13))]	= I(24),
			[B(NI_PFI(14))]	= I(25),
			[B(NI_PFI(15))]	= I(26),
			[B(TRIGGER_LINE(0))]	= I(11),
			[B(TRIGGER_LINE(1))]	= I(12),
			[B(TRIGGER_LINE(2))]	= I(13),
			[B(TRIGGER_LINE(3))]	= I(14),
			[B(TRIGGER_LINE(4))]	= I(15),
			[B(TRIGGER_LINE(5))]	= I(16),
			[B(TRIGGER_LINE(6))]	= I(17),
			[B(TRIGGER_LINE(7))]	= I(27),
			[B(PXI_Star)]	= I(20),
			[B(NI_AnalogComparisonEvent)]	= I(30),
			[B(NI_LogicLow)]	= I(31),
		},
		[B(NI_CtrArmStartTrigger(0))] = {
			/* these are just a guess; see GATE SELECT NOTE */
			[B(NI_PFI(0))]	= I(1),
			[B(NI_PFI(1))]	= I(2),
			[B(NI_PFI(2))]	= I(3),
			[B(NI_PFI(3))]	= I(4),
			[B(NI_PFI(4))]	= I(5),
			[B(NI_PFI(5))]	= I(6),
			[B(NI_PFI(6))]	= I(7),
			[B(NI_PFI(7))]	= I(8),
			[B(NI_PFI(8))]	= I(9),
			[B(NI_PFI(9))]	= I(10),
			[B(NI_PFI(10))]	= I(21),
			[B(NI_PFI(11))]	= I(22),
			[B(NI_PFI(12))]	= I(23),
			[B(NI_PFI(13))]	= I(24),
			[B(NI_PFI(14))]	= I(25),
			[B(NI_PFI(15))]	= I(26),
			[B(TRIGGER_LINE(0))]	= I(11),
			[B(TRIGGER_LINE(1))]	= I(12),
			[B(TRIGGER_LINE(2))]	= I(13),
			[B(TRIGGER_LINE(3))]	= I(14),
			[B(TRIGGER_LINE(4))]	= I(15),
			[B(TRIGGER_LINE(5))]	= I(16),
			[B(TRIGGER_LINE(6))]	= I(17),
			[B(TRIGGER_LINE(7))]	= I(27),
			[B(NI_CtrSource(1))]	= I(29),
			/* source for following line:  mhddk GP examples */
			[B(NI_CtrInternalOutput(1))]	= I(20),
			[B(PXI_Star)]	= I(19),
			[B(NI_AI_StartTrigger)]	= I(28),
			[B(NI_AI_ReferenceTrigger)]	= I(18),
			[B(NI_AnalogComparisonEvent)]	= I(30),
			[B(NI_LogicLow)]	= I(31),
		},
		[B(NI_CtrArmStartTrigger(1))] = {
			/* these are just a guess; see GATE SELECT NOTE */
			[B(NI_PFI(0))]	= I(1),
			[B(NI_PFI(1))]	= I(2),
			[B(NI_PFI(2))]	= I(3),
			[B(NI_PFI(3))]	= I(4),
			[B(NI_PFI(4))]	= I(5),
			[B(NI_PFI(5))]	= I(6),
			[B(NI_PFI(6))]	= I(7),
			[B(NI_PFI(7))]	= I(8),
			[B(NI_PFI(8))]	= I(9),
			[B(NI_PFI(9))]	= I(10),
			[B(NI_PFI(10))]	= I(21),
			[B(NI_PFI(11))]	= I(22),
			[B(NI_PFI(12))]	= I(23),
			[B(NI_PFI(13))]	= I(24),
			[B(NI_PFI(14))]	= I(25),
			[B(NI_PFI(15))]	= I(26),
			[B(TRIGGER_LINE(0))]	= I(11),
			[B(TRIGGER_LINE(1))]	= I(12),
			[B(TRIGGER_LINE(2))]	= I(13),
			[B(TRIGGER_LINE(3))]	= I(14),
			[B(TRIGGER_LINE(4))]	= I(15),
			[B(TRIGGER_LINE(5))]	= I(16),
			[B(TRIGGER_LINE(6))]	= I(17),
			[B(TRIGGER_LINE(7))]	= I(27),
			[B(NI_CtrSource(0))]	= I(29),
			/* source for following line:  mhddk GP examples */
			[B(NI_CtrInternalOutput(0))]	= I(20),
			[B(PXI_Star)]	= I(19),
			[B(NI_AI_StartTrigger)]	= I(28),
			[B(NI_AI_ReferenceTrigger)]	= I(18),
			[B(NI_AnalogComparisonEvent)]	= I(30),
			[B(NI_LogicLow)]	= I(31),
		},
		[B(NI_CtrOut(0))] = {
			[B(TRIGGER_LINE(0))]	= I(1),
			[B(TRIGGER_LINE(1))]	= I(2),
			[B(TRIGGER_LINE(2))]	= I(3),
			[B(TRIGGER_LINE(3))]	= I(4),
			[B(TRIGGER_LINE(4))]	= I(5),
			[B(TRIGGER_LINE(5))]	= I(6),
			[B(TRIGGER_LINE(6))]	= I(7),
			[B(NI_CtrInternalOutput(0))]	= I(0),
		},
		[B(NI_CtrOut(1))] = {
			[B(NI_CtrInternalOutput(1))]	= I(0),
		},
		[B(NI_AI_SampleClock)] = {
			[B(NI_PFI(0))]	= I(1),
			[B(NI_PFI(1))]	= I(2),
			[B(NI_PFI(2))]	= I(3),
			[B(NI_PFI(3))]	= I(4),
			[B(NI_PFI(4))]	= I(5),
			[B(NI_PFI(5))]	= I(6),
			[B(NI_PFI(6))]	= I(7),
			[B(NI_PFI(7))]	= I(8),
			[B(NI_PFI(8))]	= I(9),
			[B(NI_PFI(9))]	= I(10),
			[B(NI_PFI(10))]	= I(21),
			[B(NI_PFI(11))]	= I(22),
			[B(NI_PFI(12))]	= I(23),
			[B(NI_PFI(13))]	= I(24),
			[B(NI_PFI(14))]	= I(25),
			[B(NI_PFI(15))]	= I(26),
			[B(TRIGGER_LINE(0))]	= I(11),
			[B(TRIGGER_LINE(1))]	= I(12),
			[B(TRIGGER_LINE(2))]	= I(13),
			[B(TRIGGER_LINE(3))]	= I(14),
			[B(TRIGGER_LINE(4))]	= I(15),
			[B(TRIGGER_LINE(5))]	= I(16),
			[B(TRIGGER_LINE(6))]	= I(17),
			[B(TRIGGER_LINE(7))]	= I(27),
			[B(NI_CtrInternalOutput(0))]	= I(19),
			[B(NI_CtrInternalOutput(1))]	= I(28),
			[B(PXI_Star)]	= I(20),
			[B(NI_AI_SampleClockTimebase)]	= I(0),
			[B(NI_AnalogComparisonEvent)]	= I(30),
			[B(NI_SCXI_Trig1)]	= I(29),
			[B(NI_LogicLow)]	= I(31),
		},
		[B(NI_AI_SampleClockTimebase)] = {
			/* These are not currently implemented in ni modules */
			[B(NI_PFI(0))]	= U(1),
			[B(NI_PFI(1))]	= U(2),
			[B(NI_PFI(2))]	= U(3),
			[B(NI_PFI(3))]	= U(4),
			[B(NI_PFI(4))]	= U(5),
			[B(NI_PFI(5))]	= U(6),
			[B(NI_PFI(6))]	= U(7),
			[B(NI_PFI(7))]	= U(8),
			[B(NI_PFI(8))]	= U(9),
			[B(NI_PFI(9))]	= U(10),
			[B(NI_PFI(10))]	= U(21),
			[B(NI_PFI(11))]	= U(22),
			[B(NI_PFI(12))]	= U(23),
			[B(NI_PFI(13))]	= U(24),
			[B(NI_PFI(14))]	= U(25),
			[B(NI_PFI(15))]	= U(26),
			[B(TRIGGER_LINE(0))]	= U(11),
			[B(TRIGGER_LINE(1))]	= U(12),
			[B(TRIGGER_LINE(2))]	= U(13),
			[B(TRIGGER_LINE(3))]	= U(14),
			[B(TRIGGER_LINE(4))]	= U(15),
			[B(TRIGGER_LINE(5))]	= U(16),
			[B(TRIGGER_LINE(6))]	= U(17),
			[B(TRIGGER_LINE(7))]	= U(27),
			[B(PXI_Star)]	= U(20),
			[B(PXI_Clk10)]	= U(29),
			/*
			 * For routes (*->NI_AI_SampleClockTimebase) and
			 * (*->NI_AO_SampleClockTimebase), tMSeries.h of MHDDK
			 * shows 0 value as selecting ground (case ground?) and
			 * 28 value selecting TIMEBASE 1.
			 */
			[B(NI_20MHzTimebase)]	= U(28),
			[B(NI_100kHzTimebase)]	= U(19),
			[B(NI_AnalogComparisonEvent)]	= U(30),
			[B(NI_LogicLow)]	= U(31),
			[B(NI_CaseGround)]	= U(0),
		},
		[B(NI_AI_StartTrigger)] = {
			[B(NI_PFI(0))]	= I(1),
			[B(NI_PFI(1))]	= I(2),
			[B(NI_PFI(2))]	= I(3),
			[B(NI_PFI(3))]	= I(4),
			[B(NI_PFI(4))]	= I(5),
			[B(NI_PFI(5))]	= I(6),
			[B(NI_PFI(6))]	= I(7),
			[B(NI_PFI(7))]	= I(8),
			[B(NI_PFI(8))]	= I(9),
			[B(NI_PFI(9))]	= I(10),
			[B(NI_PFI(10))]	= I(21),
			[B(NI_PFI(11))]	= I(22),
			[B(NI_PFI(12))]	= I(23),
			[B(NI_PFI(13))]	= I(24),
			[B(NI_PFI(14))]	= I(25),
			[B(NI_PFI(15))]	= I(26),
			[B(TRIGGER_LINE(0))]	= I(11),
			[B(TRIGGER_LINE(1))]	= I(12),
			[B(TRIGGER_LINE(2))]	= I(13),
			[B(TRIGGER_LINE(3))]	= I(14),
			[B(TRIGGER_LINE(4))]	= I(15),
			[B(TRIGGER_LINE(5))]	= I(16),
			[B(TRIGGER_LINE(6))]	= I(17),
			[B(TRIGGER_LINE(7))]	= I(27),
			[B(NI_CtrInternalOutput(0))]	= I(18),
			[B(NI_CtrInternalOutput(1))]	= I(19),
			[B(PXI_Star)]	= I(20),
			[B(NI_AnalogComparisonEvent)]	= I(30),
			[B(NI_LogicLow)]	= I(31),
		},
		[B(NI_AI_ReferenceTrigger)] = {
			/* These are not currently implemented in ni modules */
			[B(NI_PFI(0))]	= U(1),
			[B(NI_PFI(1))]	= U(2),
			[B(NI_PFI(2))]	= U(3),
			[B(NI_PFI(3))]	= U(4),
			[B(NI_PFI(4))]	= U(5),
			[B(NI_PFI(5))]	= U(6),
			[B(NI_PFI(6))]	= U(7),
			[B(NI_PFI(7))]	= U(8),
			[B(NI_PFI(8))]	= U(9),
			[B(NI_PFI(9))]	= U(10),
			[B(NI_PFI(10))]	= U(21),
			[B(NI_PFI(11))]	= U(22),
			[B(NI_PFI(12))]	= U(23),
			[B(NI_PFI(13))]	= U(24),
			[B(NI_PFI(14))]	= U(25),
			[B(NI_PFI(15))]	= U(26),
			[B(TRIGGER_LINE(0))]	= U(11),
			[B(TRIGGER_LINE(1))]	= U(12),
			[B(TRIGGER_LINE(2))]	= U(13),
			[B(TRIGGER_LINE(3))]	= U(14),
			[B(TRIGGER_LINE(4))]	= U(15),
			[B(TRIGGER_LINE(5))]	= U(16),
			[B(TRIGGER_LINE(6))]	= U(17),
			[B(TRIGGER_LINE(7))]	= U(27),
			[B(PXI_Star)]	= U(20),
			[B(NI_AnalogComparisonEvent)]	= U(30),
			[B(NI_LogicLow)]	= U(31),
		},
		[B(NI_AI_ConvertClock)] = {
			[B(NI_PFI(0))]	= I(1),
			[B(NI_PFI(1))]	= I(2),
			[B(NI_PFI(2))]	= I(3),
			[B(NI_PFI(3))]	= I(4),
			[B(NI_PFI(4))]	= I(5),
			[B(NI_PFI(5))]	= I(6),
			[B(NI_PFI(6))]	= I(7),
			[B(NI_PFI(7))]	= I(8),
			[B(NI_PFI(8))]	= I(9),
			[B(NI_PFI(9))]	= I(10),
			[B(NI_PFI(10))]	= I(21),
			[B(NI_PFI(11))]	= I(22),
			[B(NI_PFI(12))]	= I(23),
			[B(NI_PFI(13))]	= I(24),
			[B(NI_PFI(14))]	= I(25),
			[B(NI_PFI(15))]	= I(26),
			[B(TRIGGER_LINE(0))]	= I(11),
			[B(TRIGGER_LINE(1))]	= I(12),
			[B(TRIGGER_LINE(2))]	= I(13),
			[B(TRIGGER_LINE(3))]	= I(14),
			[B(TRIGGER_LINE(4))]	= I(15),
			[B(TRIGGER_LINE(5))]	= I(16),
			[B(TRIGGER_LINE(6))]	= I(17),
			[B(TRIGGER_LINE(7))]	= I(27),
			/* source for following line:  mhddk example headers */
			[B(NI_CtrInternalOutput(0))]	= I(19),
			/* source for following line:  mhddk example headers */
			[B(NI_CtrInternalOutput(1))]	= I(18),
			[B(PXI_Star)]	= I(20),
			[B(NI_AI_ConvertClockTimebase)]	= I(0),
			[B(NI_AnalogComparisonEvent)]	= I(30),
			[B(NI_LogicLow)]	= I(31),
		},
		[B(NI_AI_ConvertClockTimebase)] = {
			/* These are not currently implemented in ni modules */
			[B(NI_AI_SampleClockTimebase)]	= U(0),
			[B(NI_20MHzTimebase)]	= U(1),
		},
		[B(NI_AI_PauseTrigger)] = {
			/* These are not currently implemented in ni modules */
			[B(NI_PFI(0))]	= U(1),
			[B(NI_PFI(1))]	= U(2),
			[B(NI_PFI(2))]	= U(3),
			[B(NI_PFI(3))]	= U(4),
			[B(NI_PFI(4))]	= U(5),
			[B(NI_PFI(5))]	= U(6),
			[B(NI_PFI(6))]	= U(7),
			[B(NI_PFI(7))]	= U(8),
			[B(NI_PFI(8))]	= U(9),
			[B(NI_PFI(9))]	= U(10),
			[B(NI_PFI(10))]	= U(21),
			[B(NI_PFI(11))]	= U(22),
			[B(NI_PFI(12))]	= U(23),
			[B(NI_PFI(13))]	= U(24),
			[B(NI_PFI(14))]	= U(25),
			[B(NI_PFI(15))]	= U(26),
			[B(TRIGGER_LINE(0))]	= U(11),
			[B(TRIGGER_LINE(1))]	= U(12),
			[B(TRIGGER_LINE(2))]	= U(13),
			[B(TRIGGER_LINE(3))]	= U(14),
			[B(TRIGGER_LINE(4))]	= U(15),
			[B(TRIGGER_LINE(5))]	= U(16),
			[B(TRIGGER_LINE(6))]	= U(17),
			[B(TRIGGER_LINE(7))]	= U(27),
			[B(PXI_Star)]	= U(20),
			[B(NI_AnalogComparisonEvent)]	= U(30),
			[B(NI_LogicLow)]	= U(31),
		},
		[B(NI_AO_SampleClock)] = {
			[B(NI_PFI(0))]	= I(1),
			[B(NI_PFI(1))]	= I(2),
			[B(NI_PFI(2))]	= I(3),
			[B(NI_PFI(3))]	= I(4),
			[B(NI_PFI(4))]	= I(5),
			[B(NI_PFI(5))]	= I(6),
			[B(NI_PFI(6))]	= I(7),
			[B(NI_PFI(7))]	= I(8),
			[B(NI_PFI(8))]	= I(9),
			[B(NI_PFI(9))]	= I(10),
			[B(NI_PFI(10))]	= I(21),
			[B(NI_PFI(11))]	= I(22),
			[B(NI_PFI(12))]	= I(23),
			[B(NI_PFI(13))]	= I(24),
			[B(NI_PFI(14))]	= I(25),
			[B(NI_PFI(15))]	= I(26),
			[B(TRIGGER_LINE(0))]	= I(11),
			[B(TRIGGER_LINE(1))]	= I(12),
			[B(TRIGGER_LINE(2))]	= I(13),
			[B(TRIGGER_LINE(3))]	= I(14),
			[B(TRIGGER_LINE(4))]	= I(15),
			[B(TRIGGER_LINE(5))]	= I(16),
			[B(TRIGGER_LINE(6))]	= I(17),
			[B(TRIGGER_LINE(7))]	= I(27),
			[B(NI_CtrInternalOutput(0))]	= I(18),
			[B(NI_CtrInternalOutput(1))]	= I(19),
			[B(PXI_Star)]	= I(20),
			[B(NI_AO_SampleClockTimebase)]	= I(0),
			[B(NI_AnalogComparisonEvent)]	= I(30),
			[B(NI_LogicLow)]	= I(31),
		},
		[B(NI_AO_SampleClockTimebase)] = {
			/* These are not currently implemented in ni modules */
			[B(NI_PFI(0))]	= U(1),
			[B(NI_PFI(1))]	= U(2),
			[B(NI_PFI(2))]	= U(3),
			[B(NI_PFI(3))]	= U(4),
			[B(NI_PFI(4))]	= U(5),
			[B(NI_PFI(5))]	= U(6),
			[B(NI_PFI(6))]	= U(7),
			[B(NI_PFI(7))]	= U(8),
			[B(NI_PFI(8))]	= U(9),
			[B(NI_PFI(9))]	= U(10),
			[B(NI_PFI(10))]	= U(21),
			[B(NI_PFI(11))]	= U(22),
			[B(NI_PFI(12))]	= U(23),
			[B(NI_PFI(13))]	= U(24),
			[B(NI_PFI(14))]	= U(25),
			[B(NI_PFI(15))]	= U(26),
			[B(TRIGGER_LINE(0))]	= U(11),
			[B(TRIGGER_LINE(1))]	= U(12),
			[B(TRIGGER_LINE(2))]	= U(13),
			[B(TRIGGER_LINE(3))]	= U(14),
			[B(TRIGGER_LINE(4))]	= U(15),
			[B(TRIGGER_LINE(5))]	= U(16),
			[B(TRIGGER_LINE(6))]	= U(17),
			[B(TRIGGER_LINE(7))]	= U(27),
			[B(PXI_Star)]	= U(20),
			[B(PXI_Clk10)]	= U(29),
			/*
			 * For routes (*->NI_AI_SampleClockTimebase) and
			 * (*->NI_AO_SampleClockTimebase), tMSeries.h of MHDDK
			 * shows 0 value as selecting ground (case ground?) and
			 * 28 value selecting TIMEBASE 1.
			 */
			[B(NI_20MHzTimebase)]	= U(28),
			[B(NI_100kHzTimebase)]	= U(19),
			[B(NI_AnalogComparisonEvent)]	= U(30),
			[B(NI_LogicLow)]	= U(31),
			[B(NI_CaseGround)]	= U(0),
		},
		[B(NI_AO_StartTrigger)] = {
			[B(NI_PFI(0))]	= I(1),
			[B(NI_PFI(1))]	= I(2),
			[B(NI_PFI(2))]	= I(3),
			[B(NI_PFI(3))]	= I(4),
			[B(NI_PFI(4))]	= I(5),
			[B(NI_PFI(5))]	= I(6),
			[B(NI_PFI(6))]	= I(7),
			[B(NI_PFI(7))]	= I(8),
			[B(NI_PFI(8))]	= I(9),
			[B(NI_PFI(9))]	= I(10),
			[B(NI_PFI(10))]	= I(21),
			[B(NI_PFI(11))]	= I(22),
			[B(NI_PFI(12))]	= I(23),
			[B(NI_PFI(13))]	= I(24),
			[B(NI_PFI(14))]	= I(25),
			[B(NI_PFI(15))]	= I(26),
			[B(TRIGGER_LINE(0))]	= I(11),
			[B(TRIGGER_LINE(1))]	= I(12),
			[B(TRIGGER_LINE(2))]	= I(13),
			[B(TRIGGER_LINE(3))]	= I(14),
			[B(TRIGGER_LINE(4))]	= I(15),
			[B(TRIGGER_LINE(5))]	= I(16),
			[B(TRIGGER_LINE(6))]	= I(17),
			[B(TRIGGER_LINE(7))]	= I(27),
			[B(PXI_Star)]	= I(20),
			/*
			 * for the signal route
			 * (NI_AI_StartTrigger->NI_AO_StartTrigger), DAQ-STC &
			 * MHDDK disagreed for e-series.  MHDDK for m-series
			 * agrees with DAQ-STC description and uses the value 18
			 * for the route
			 * (NI_AI_ReferenceTrigger->NI_AO_StartTrigger).  The
			 * m-series devices are supposed to have DAQ-STC2.
			 * There are no DAQ-STC2 docs to compare with.
			 */
			[B(NI_AI_StartTrigger)]	= I(19),
			[B(NI_AI_ReferenceTrigger)]	= I(18),
			[B(NI_AnalogComparisonEvent)]	= I(30),
			[B(NI_LogicLow)]	= I(31),
		},
		[B(NI_AO_PauseTrigger)] = {
			/* These are not currently implemented in ni modules */
			[B(NI_PFI(0))]	= U(1),
			[B(NI_PFI(1))]	= U(2),
			[B(NI_PFI(2))]	= U(3),
			[B(NI_PFI(3))]	= U(4),
			[B(NI_PFI(4))]	= U(5),
			[B(NI_PFI(5))]	= U(6),
			[B(NI_PFI(6))]	= U(7),
			[B(NI_PFI(7))]	= U(8),
			[B(NI_PFI(8))]	= U(9),
			[B(NI_PFI(9))]	= U(10),
			[B(NI_PFI(10))]	= U(21),
			[B(NI_PFI(11))]	= U(22),
			[B(NI_PFI(12))]	= U(23),
			[B(NI_PFI(13))]	= U(24),
			[B(NI_PFI(14))]	= U(25),
			[B(NI_PFI(15))]	= U(26),
			[B(TRIGGER_LINE(0))]	= U(11),
			[B(TRIGGER_LINE(1))]	= U(12),
			[B(TRIGGER_LINE(2))]	= U(13),
			[B(TRIGGER_LINE(3))]	= U(14),
			[B(TRIGGER_LINE(4))]	= U(15),
			[B(TRIGGER_LINE(5))]	= U(16),
			[B(TRIGGER_LINE(6))]	= U(17),
			[B(TRIGGER_LINE(7))]	= U(27),
			[B(PXI_Star)]	= U(20),
			[B(NI_AnalogComparisonEvent)]	= U(30),
			[B(NI_LogicLow)]	= U(31),
		},
		[B(NI_DI_SampleClock)] = {
			[B(NI_PFI(0))]	= I(1),
			[B(NI_PFI(1))]	= I(2),
			[B(NI_PFI(2))]	= I(3),
			[B(NI_PFI(3))]	= I(4),
			[B(NI_PFI(4))]	= I(5),
			[B(NI_PFI(5))]	= I(6),
			[B(NI_PFI(6))]	= I(7),
			[B(NI_PFI(7))]	= I(8),
			[B(NI_PFI(8))]	= I(9),
			[B(NI_PFI(9))]	= I(10),
			[B(NI_PFI(10))]	= I(21),
			[B(NI_PFI(11))]	= I(22),
			[B(NI_PFI(12))]	= I(23),
			[B(NI_PFI(13))]	= I(24),
			[B(NI_PFI(14))]	= I(25),
			[B(NI_PFI(15))]	= I(26),
			[B(TRIGGER_LINE(0))]	= I(11),
			[B(TRIGGER_LINE(1))]	= I(12),
			[B(TRIGGER_LINE(2))]	= I(13),
			[B(TRIGGER_LINE(3))]	= I(14),
			[B(TRIGGER_LINE(4))]	= I(15),
			[B(TRIGGER_LINE(5))]	= I(16),
			[B(TRIGGER_LINE(6))]	= I(17),
			[B(TRIGGER_LINE(7))]	= I(27),
			[B(NI_CtrInternalOutput(0))]	= I(28),
			[B(NI_CtrInternalOutput(1))]	= I(29),
			[B(PXI_Star)]	= I(20),
			[B(NI_AI_SampleClock)]	= I(18),
			[B(NI_AI_ConvertClock)]	= I(19),
			[B(NI_AO_SampleClock)]	= I(31),
			[B(NI_FrequencyOutput)]	= I(32),
			[B(NI_ChangeDetectionEvent)]	= I(33),
			[B(NI_CaseGround)]	= I(0),
		},
		[B(NI_DO_SampleClock)] = {
			[B(NI_PFI(0))]	= I(1),
			[B(NI_PFI(1))]	= I(2),
			[B(NI_PFI(2))]	= I(3),
			[B(NI_PFI(3))]	= I(4),
			[B(NI_PFI(4))]	= I(5),
			[B(NI_PFI(5))]	= I(6),
			[B(NI_PFI(6))]	= I(7),
			[B(NI_PFI(7))]	= I(8),
			[B(NI_PFI(8))]	= I(9),
			[B(NI_PFI(9))]	= I(10),
			[B(NI_PFI(10))]	= I(21),
			[B(NI_PFI(11))]	= I(22),
			[B(NI_PFI(12))]	= I(23),
			[B(NI_PFI(13))]	= I(24),
			[B(NI_PFI(14))]	= I(25),
			[B(NI_PFI(15))]	= I(26),
			[B(TRIGGER_LINE(0))]	= I(11),
			[B(TRIGGER_LINE(1))]	= I(12),
			[B(TRIGGER_LINE(2))]	= I(13),
			[B(TRIGGER_LINE(3))]	= I(14),
			[B(TRIGGER_LINE(4))]	= I(15),
			[B(TRIGGER_LINE(5))]	= I(16),
			[B(TRIGGER_LINE(6))]	= I(17),
			[B(TRIGGER_LINE(7))]	= I(27),
			[B(NI_CtrInternalOutput(0))]	= I(28),
			[B(NI_CtrInternalOutput(1))]	= I(29),
			[B(PXI_Star)]	= I(20),
			[B(NI_AI_SampleClock)]	= I(18),
			[B(NI_AI_ConvertClock)]	= I(19),
			[B(NI_AO_SampleClock)]	= I(31),
			[B(NI_FrequencyOutput)]	= I(32),
			[B(NI_ChangeDetectionEvent)]	= I(33),
			[B(NI_CaseGround)]	= I(0),
		},
		[B(NI_MasterTimebase)] = {
			/* These are not currently implemented in ni modules */
			[B(TRIGGER_LINE(0))]	= U(11),
			[B(TRIGGER_LINE(1))]	= U(12),
			[B(TRIGGER_LINE(2))]	= U(13),
			[B(TRIGGER_LINE(3))]	= U(14),
			[B(TRIGGER_LINE(4))]	= U(15),
			[B(TRIGGER_LINE(5))]	= U(16),
			[B(TRIGGER_LINE(6))]	= U(17),
			[B(TRIGGER_LINE(7))]	= U(27),
			[B(PXI_Star)]	= U(20),
			[B(PXI_Clk10)]	= U(29),
			[B(NI_10MHzRefClock)]	= U(0),
		},
		/*
		 * This symbol is not defined and nothing for this is
		 * implemented--just including this because data was found in
		 * the NI-STC for it--can't remember where.
		 * [B(NI_FrequencyOutTimebase)] = {
		 *	** These are not currently implemented in ni modules **
		 *	[B(NI_20MHzTimebase)]	= U(0),
		 *	[B(NI_100kHzTimebase)]	= U(1),
		 * },
		 */
		[B(NI_RGOUT0)] = {
			[B(NI_CtrInternalOutput(0))]	= I(0),
			[B(NI_CtrOut(0))]	= I(1),
		},
	},
};
