/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.graph;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import org.jgraph.JGraph;
import org.jgraph.graph.CellView;

public class BasicMarqueeHandler {
    protected transient Cursor previousCursor = null;
    protected Rectangle2D marqueeBounds;
    protected Point2D startPoint;
    protected Point2D currentPoint;

    public boolean isForceMarqueeEvent(MouseEvent mouseEvent) {
        return mouseEvent.isAltDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseReleased(MouseEvent mouseEvent) {
        try {
            if (mouseEvent != null && this.marqueeBounds != null) {
                if (!(mouseEvent.getSource() instanceof JGraph)) {
                    throw new IllegalArgumentException("MarqueeHandler cannot handle event from unknown source: " + mouseEvent);
                }
                JGraph jGraph = (JGraph)mouseEvent.getSource();
                Rectangle2D rectangle2D = jGraph.fromScreen((Rectangle2D)this.marqueeBounds.clone());
                this.handleMarqueeEvent(mouseEvent, jGraph, rectangle2D);
                jGraph.setCursor(this.previousCursor);
                Rectangle rectangle = new Rectangle((int)this.marqueeBounds.getX(), (int)this.marqueeBounds.getY(), (int)this.marqueeBounds.getWidth() + 1, (int)this.marqueeBounds.getHeight() + 1);
                ++rectangle.width;
                ++rectangle.height;
                jGraph.repaint(rectangle);
            }
            Object var6_5 = null;
            this.currentPoint = null;
            this.startPoint = null;
            this.marqueeBounds = null;
            this.previousCursor = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.currentPoint = null;
            this.startPoint = null;
            this.marqueeBounds = null;
            this.previousCursor = null;
            throw throwable;
        }
    }

    public void handleMarqueeEvent(MouseEvent mouseEvent, JGraph jGraph, Rectangle2D rectangle2D) {
        CellView[] cellViewArray = jGraph.getGraphLayoutCache().getRoots(rectangle2D);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < cellViewArray.length; ++i) {
            if (!rectangle2D.contains(cellViewArray[i].getBounds())) continue;
            arrayList.add(cellViewArray[i].getCell());
        }
        Object[] objectArray = arrayList.toArray();
        jGraph.getUI().selectCellsForEvent(jGraph, objectArray, mouseEvent);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.startPoint != null) {
            if (!(mouseEvent.getSource() instanceof JGraph)) {
                throw new IllegalArgumentException("MarqueeHandler cannot handle event from unknown source: " + mouseEvent);
            }
            JGraph jGraph = (JGraph)mouseEvent.getSource();
            Graphics graphics = jGraph.getGraphics();
            Color color = jGraph.getBackground();
            Color color2 = jGraph.getMarqueeColor();
            if (jGraph.isXorEnabled()) {
                graphics.setColor(color2);
                graphics.setXORMode(color);
                this.overlay(jGraph, graphics, true);
            }
            Rectangle2D rectangle2D = (Rectangle2D)this.marqueeBounds.clone();
            this.processMouseDraggedEvent(mouseEvent);
            if (jGraph.isXorEnabled()) {
                graphics.setColor(color);
                graphics.setXORMode(color2);
                this.overlay(jGraph, graphics, false);
            } else {
                rectangle2D.add(this.marqueeBounds);
                jGraph.repaint((int)rectangle2D.getX() - 1, (int)rectangle2D.getY() - 1, (int)rectangle2D.getWidth() + 2, (int)rectangle2D.getHeight() + 2);
            }
        }
    }

    protected void processMouseDraggedEvent(MouseEvent mouseEvent) {
        if (this.startPoint != null) {
            this.currentPoint = mouseEvent.getPoint();
            this.marqueeBounds = new Rectangle2D.Double(this.startPoint.getX(), this.startPoint.getY(), 0.0, 0.0);
            this.marqueeBounds.add(this.currentPoint);
        }
    }

    public void paint(JGraph jGraph, Graphics graphics) {
        if (this.marqueeBounds != null) {
            if (jGraph.isXorEnabled()) {
                Color color = jGraph.getBackground();
                Color color2 = jGraph.getMarqueeColor();
                graphics.setColor(color2);
                graphics.setXORMode(color);
            }
            this.overlay(jGraph, graphics, false);
        }
    }

    public void overlay(JGraph jGraph, Graphics graphics, boolean bl) {
        if (this.marqueeBounds != null) {
            if (!jGraph.isXorEnabled()) {
                graphics.setColor(jGraph.getMarqueeColor());
            }
            graphics.drawRect((int)this.marqueeBounds.getX(), (int)this.marqueeBounds.getY(), (int)this.marqueeBounds.getWidth(), (int)this.marqueeBounds.getHeight());
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.startPoint = mouseEvent.getPoint();
        this.marqueeBounds = new Rectangle2D.Double(this.startPoint.getX(), this.startPoint.getY(), 0.0, 0.0);
        if (!(mouseEvent.getSource() instanceof JGraph)) {
            throw new IllegalArgumentException("MarqueeHandler cannot handle event from unknown source: " + mouseEvent);
        }
        JGraph jGraph = (JGraph)mouseEvent.getSource();
        if (this.isMarqueeTriggerEvent(mouseEvent, jGraph)) {
            this.previousCursor = jGraph.getCursor();
            jGraph.setCursor(new Cursor(1));
        }
    }

    public boolean isMarqueeTriggerEvent(MouseEvent mouseEvent, JGraph jGraph) {
        return jGraph.isSelectionEnabled();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public Point2D getCurrentPoint() {
        return this.currentPoint;
    }

    public Rectangle2D getMarqueeBounds() {
        return this.marqueeBounds;
    }

    public Cursor getPreviousCursor() {
        return this.previousCursor;
    }

    public Point2D getStartPoint() {
        return this.startPoint;
    }

    public void setCurrentPoint(Point2D point2D) {
        this.currentPoint = point2D;
    }

    public void setMarqueeBounds(Rectangle2D rectangle2D) {
        this.marqueeBounds = rectangle2D;
    }

    public void setPreviousCursor(Cursor cursor) {
        this.previousCursor = cursor;
    }

    public void setStartPoint(Point2D point2D) {
        this.startPoint = point2D;
    }

    public static JGraph getGraphForEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() instanceof JGraph) {
            return (JGraph)mouseEvent.getSource();
        }
        return null;
    }
}

