#!./perl

use strict;
use warnings;
use utf8;
use open qw( :utf8 :std );

require q(./test.pl); plan(tests => 10);

=pod

This example is take from: http://www.python.org/2.3/mro.html

"My first example"
class O: pass
class F(O): pass
class E(O): pass
class D(O): pass
class C(D,F): pass
class B(D,E): pass
class A(B,C): pass


                          6
                         ---
Level 3                 | O |                  (more general)
                      /  ---  \
                     /    |    \                      |
                    /     |     \                     |
                   /      |      \                    |
                  ---    ---    ---                   |
Level 2        3 | D | 4| E |  | F | 5                |
                  ---    ---    ---                   |
                   \  \ _ /       |                   |
                    \    / \ _    |                   |
                     \  /      \  |                   |
                      ---      ---                    |
Level 1            1 | B |    | C | 2                 |
                      ---      ---                    |
                        \      /                      |
                         \    /                      \ /
                           ---
Level 0                 0 | A |                (more specialized)
                           ---

=cut

{
    package 텟ţ::ᴼ;
    use mro 'c3'; 
    
    package 텟ţ::Ḟ;   
    use mro 'c3';  
    use base '텟ţ::ᴼ';        
    
    package 텟ţ::ऍ;
    use base '텟ţ::ᴼ';    
    use mro 'c3';     
    
    sub ƈ_or_ऍ { '텟ţ::ऍ' }

    package 텟ţ::Ḋ;
    use mro 'c3'; 
    use base '텟ţ::ᴼ';     
    
    sub ƈ_or_Ḋ { '텟ţ::Ḋ' }       
      
    package 텟ţ::ƈ;
    use base ('텟ţ::Ḋ', '텟ţ::Ḟ');
    use mro 'c3'; 
    
    sub ƈ_or_Ḋ { '텟ţ::ƈ' }
    sub ƈ_or_ऍ { '텟ţ::ƈ' }    
        
    package 텟ţ::ᛒ;    
    use mro 'c3'; 
    use base ('텟ţ::Ḋ', '텟ţ::ऍ');    
        
    package 텟ţ::ଅ;    
    use base ('텟ţ::ᛒ', '텟ţ::ƈ');
    use mro 'c3';    
}

ok(eq_array(
    mro::get_linear_isa('텟ţ::Ḟ'),
    [ qw(텟ţ::Ḟ 텟ţ::ᴼ) ]
), '... got the right MRO for 텟ţ::Ḟ');

ok(eq_array(
    mro::get_linear_isa('텟ţ::ऍ'),
    [ qw(텟ţ::ऍ 텟ţ::ᴼ) ]
), '... got the right MRO for 텟ţ::ऍ');    

ok(eq_array(
    mro::get_linear_isa('텟ţ::Ḋ'),
    [ qw(텟ţ::Ḋ 텟ţ::ᴼ) ]
), '... got the right MRO for 텟ţ::Ḋ');       

ok(eq_array(
    mro::get_linear_isa('텟ţ::ƈ'),
    [ qw(텟ţ::ƈ 텟ţ::Ḋ 텟ţ::Ḟ 텟ţ::ᴼ) ]
), '... got the right MRO for 텟ţ::ƈ'); 

ok(eq_array(
    mro::get_linear_isa('텟ţ::ᛒ'),
    [ qw(텟ţ::ᛒ 텟ţ::Ḋ 텟ţ::ऍ 텟ţ::ᴼ) ]
), '... got the right MRO for 텟ţ::ᛒ');     

ok(eq_array(
    mro::get_linear_isa('텟ţ::ଅ'),
    [ qw(텟ţ::ଅ 텟ţ::ᛒ 텟ţ::ƈ 텟ţ::Ḋ 텟ţ::ऍ 텟ţ::Ḟ 텟ţ::ᴼ) ]
), '... got the right MRO for 텟ţ::ଅ');  
    
is(텟ţ::ଅ->ƈ_or_Ḋ, '텟ţ::ƈ', '... got the expected method output');
is(텟ţ::ଅ->can('ƈ_or_Ḋ')->(), '텟ţ::ƈ', '... can got the expected method output');
is(텟ţ::ଅ->ƈ_or_ऍ, '텟ţ::ƈ', '... got the expected method output');
is(텟ţ::ଅ->can('ƈ_or_ऍ')->(), '텟ţ::ƈ', '... can got the expected method output');
