/*
 * Decompiled with CFR 0.152.
 */
package org.gagravarr.flac;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.gagravarr.flac.FlacAudioFrame;
import org.gagravarr.flac.FlacFile;
import org.gagravarr.flac.FlacInfo;
import org.gagravarr.flac.FlacMetadataBlock;
import org.gagravarr.flac.FlacTags;
import org.gagravarr.ogg.IOUtils;

public class FlacNativeFile
extends FlacFile {
    private InputStream input;

    public FlacNativeFile(File f) throws IOException, FileNotFoundException {
        this(new FileInputStream(f));
    }

    public FlacNativeFile(InputStream inp) throws IOException {
        FlacMetadataBlock m;
        byte[] header = new byte[4];
        IOUtils.readFully(inp, header);
        if (header[0] != 102 || header[1] != 76 || header[2] != 97 || header[3] != 67) {
            throw new IllegalArgumentException("Not a FLAC file");
        }
        this.info = (FlacInfo)FlacMetadataBlock.create(inp);
        this.otherMetadata = new ArrayList();
        do {
            if ((m = FlacMetadataBlock.create(inp)) instanceof FlacTags.FlacTagsAsMetadata) {
                this.tags = ((FlacTags.FlacTagsAsMetadata)m).getTags();
                continue;
            }
            this.otherMetadata.add(m);
        } while (!m.isLastMetadataBlock());
    }

    public FlacAudioFrame getNextAudioPacket() throws IOException {
        return new FlacAudioFrame(null);
    }

    public void skipToGranule(long granulePosition) throws IOException {
        throw new RuntimeException("Not supported");
    }

    public void close() throws IOException {
        if (this.input == null) {
            throw new RuntimeException("Not supported");
        }
        this.input.close();
        this.input = null;
    }
}

